/*
 * Decompiled with CFR 0.152.
 */
package com.sun.marlin;

import com.sun.marlin.FloatMath;
import com.sun.marlin.MarlinConst;
import com.sun.marlin.MarlinUtils;
import java.security.AccessController;

public final class MarlinProperties {
    private MarlinProperties() {
    }

    public static boolean isUseThreadLocal() {
        return MarlinProperties.getBoolean("prism.marlin.useThreadLocal", "true");
    }

    public static int getInitialEdges() {
        return MarlinProperties.align(MarlinProperties.getInteger("prism.marlin.edges", 4096, 64, 65536), 64);
    }

    public static int getInitialPixelWidth() {
        return MarlinProperties.align(MarlinProperties.getInteger("prism.marlin.pixelWidth", 4096, 64, 32768), 64);
    }

    public static int getInitialPixelHeight() {
        return MarlinProperties.align(MarlinProperties.getInteger("prism.marlin.pixelHeight", 2176, 64, 32768), 64);
    }

    public static boolean isProfileQuality() {
        String key = "prism.marlin.profile";
        String profile = MarlinProperties.getString("prism.marlin.profile", "quality");
        if ("quality".equals(profile)) {
            return true;
        }
        if ("speed".equals(profile)) {
            return false;
        }
        MarlinUtils.logInfo("Invalid value for prism.marlin.profile = " + profile + "; expect value in [quality, speed] !");
        return true;
    }

    public static int getSubPixel_Log2_X() {
        return MarlinProperties.getInteger("prism.marlin.subPixel_log2_X", 8, 0, 8);
    }

    public static int getSubPixel_Log2_Y() {
        int def = MarlinProperties.isProfileQuality() ? 3 : 2;
        return MarlinProperties.getInteger("prism.marlin.subPixel_log2_Y", def, 0, 8);
    }

    public static int getBlockSize_Log2() {
        return MarlinProperties.getInteger("prism.marlin.blockSize_log2", 5, 3, 8);
    }

    public static boolean isForceRLE() {
        return MarlinProperties.getBoolean("prism.marlin.forceRLE", "false");
    }

    public static boolean isForceNoRLE() {
        return MarlinProperties.getBoolean("prism.marlin.forceNoRLE", "false");
    }

    public static boolean isUseTileFlags() {
        return MarlinProperties.getBoolean("prism.marlin.useTileFlags", "true");
    }

    public static boolean isUseTileFlagsWithHeuristics() {
        return MarlinProperties.isUseTileFlags() && MarlinProperties.getBoolean("prism.marlin.useTileFlags.useHeuristics", "true");
    }

    public static int getRLEMinWidth() {
        return MarlinProperties.getInteger("prism.marlin.rleMinWidth", 64, 0, Integer.MAX_VALUE);
    }

    public static boolean isUseSimplifier() {
        return MarlinProperties.getBoolean("prism.marlin.useSimplifier", "false");
    }

    public static boolean isUsePathSimplifier() {
        return MarlinProperties.getBoolean("prism.marlin.usePathSimplifier", "false");
    }

    public static float getPathSimplifierPixelTolerance() {
        return MarlinProperties.getFloat("prism.marlin.pathSimplifier.pixTol", 1.0f / MarlinConst.MIN_SUBPIXELS, 0.001f, 10.0f);
    }

    public static boolean isDoClip() {
        return MarlinProperties.getBoolean("prism.marlin.clip", "true");
    }

    public static boolean isDoClipRuntimeFlag() {
        return MarlinProperties.getBoolean("prism.marlin.clip.runtime.enable", "false");
    }

    public static boolean isDoClipAtRuntime() {
        return MarlinProperties.getBoolean("prism.marlin.clip.runtime", "true");
    }

    public static boolean isDoClipSubdivider() {
        return MarlinProperties.getBoolean("prism.marlin.clip.subdivider", "true");
    }

    public static float getSubdividerMinLength() {
        return MarlinProperties.getFloat("prism.marlin.clip.subdivider.minLength", 100.0f, Float.NEGATIVE_INFINITY, Float.POSITIVE_INFINITY);
    }

    public static boolean isDoStats() {
        return MarlinProperties.getBoolean("prism.marlin.doStats", "false");
    }

    public static boolean isDoMonitors() {
        return MarlinProperties.getBoolean("prism.marlin.doMonitors", "false");
    }

    public static boolean isDoChecks() {
        return MarlinProperties.getBoolean("prism.marlin.doChecks", "false");
    }

    public static boolean isLoggingEnabled() {
        return MarlinProperties.getBoolean("prism.marlin.log", "false");
    }

    public static boolean isUseLogger() {
        return MarlinProperties.getBoolean("prism.marlin.useLogger", "false");
    }

    public static boolean isLogCreateContext() {
        return MarlinProperties.getBoolean("prism.marlin.logCreateContext", "false");
    }

    public static boolean isLogUnsafeMalloc() {
        return MarlinProperties.getBoolean("prism.marlin.logUnsafeMalloc", "false");
    }

    public static float getCurveLengthError() {
        return MarlinProperties.getFloat("prism.marlin.curve_len_err", 0.01f, 1.0E-6f, 1.0f);
    }

    public static float getCubicDecD2() {
        float def = MarlinProperties.isProfileQuality() ? 1.0f : 2.5f;
        return MarlinProperties.getFloat("prism.marlin.cubic_dec_d2", def, 1.0E-5f, 4.0f);
    }

    public static float getCubicIncD1() {
        float def = MarlinProperties.isProfileQuality() ? 0.2f : 0.5f;
        return MarlinProperties.getFloat("prism.marlin.cubic_inc_d1", def, 1.0E-6f, 1.0f);
    }

    public static float getQuadDecD2() {
        float def = MarlinProperties.isProfileQuality() ? 0.5f : 1.0f;
        return MarlinProperties.getFloat("prism.marlin.quad_dec_d2", def, 1.0E-5f, 4.0f);
    }

    static String getString(String key, String def) {
        return AccessController.doPrivileged(() -> {
            String value = System.getProperty(key);
            return value == null ? def : value;
        });
    }

    static boolean getBoolean(String key, String def) {
        return Boolean.valueOf(AccessController.doPrivileged(() -> {
            String value = System.getProperty(key);
            return value == null ? def : value;
        }));
    }

    static int getInteger(String key, int def, int min, int max) {
        String property = AccessController.doPrivileged(() -> System.getProperty(key));
        int value = def;
        if (property != null) {
            try {
                value = Integer.decode(property);
            }
            catch (NumberFormatException e) {
                MarlinUtils.logInfo("Invalid integer value for " + key + " = " + property);
            }
        }
        if (value < min || value > max) {
            MarlinUtils.logInfo("Invalid value for " + key + " = " + value + "; expected value in range[" + min + ", " + max + "] !");
            value = def;
        }
        return value;
    }

    static int align(int val, int norm) {
        int ceil = FloatMath.ceil_int((float)val / (float)norm);
        return ceil * norm;
    }

    public static double getDouble(String key, double def, double min, double max) {
        double value = def;
        String property = AccessController.doPrivileged(() -> System.getProperty(key));
        if (property != null) {
            try {
                value = Double.parseDouble(property);
            }
            catch (NumberFormatException nfe) {
                MarlinUtils.logInfo("Invalid value for " + key + " = " + property + " !");
            }
        }
        if (value < min || value > max) {
            MarlinUtils.logInfo("Invalid value for " + key + " = " + value + "; expect value in range[" + min + ", " + max + "] !");
            value = def;
        }
        return value;
    }

    public static float getFloat(String key, float def, float min, float max) {
        return (float)MarlinProperties.getDouble(key, def, min, max);
    }
}

