/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javafx.tk.quantum;

import com.sun.javafx.geom.DirtyRegionContainer;
import com.sun.javafx.geom.DirtyRegionPool;
import com.sun.javafx.geom.RectBounds;
import com.sun.javafx.geom.Rectangle;
import com.sun.javafx.geom.transform.Affine3D;
import com.sun.javafx.geom.transform.BaseTransform;
import com.sun.javafx.geom.transform.GeneralTransform3D;
import com.sun.javafx.logging.PulseLogger;
import com.sun.javafx.sg.prism.NGCamera;
import com.sun.javafx.sg.prism.NGNode;
import com.sun.javafx.sg.prism.NGPerspectiveCamera;
import com.sun.javafx.sg.prism.NodePath;
import com.sun.javafx.tk.quantum.GlassScene;
import com.sun.javafx.tk.quantum.SceneState;
import com.sun.prism.Graphics;
import com.sun.prism.GraphicsResource;
import com.sun.prism.Image;
import com.sun.prism.Presentable;
import com.sun.prism.RTTexture;
import com.sun.prism.ResourceFactory;
import com.sun.prism.Texture;
import com.sun.prism.impl.PrismSettings;
import com.sun.prism.paint.Color;
import com.sun.prism.paint.Paint;
import java.util.ArrayList;
import java.util.concurrent.locks.ReentrantLock;

abstract class ViewPainter
implements Runnable {
    private static NodePath[] ROOT_PATHS = new NodePath[PrismSettings.dirtyRegionCount];
    protected static final ReentrantLock renderLock = new ReentrantLock();
    protected int penWidth = -1;
    protected int penHeight = -1;
    protected int viewWidth;
    protected int viewHeight;
    protected final SceneState sceneState;
    protected Presentable presentable;
    protected ResourceFactory factory;
    protected boolean freshBackBuffer;
    private int width;
    private int height;
    private NGNode root;
    private NGNode overlayRoot;
    private Rectangle dirtyRect;
    private RectBounds clip;
    private RectBounds dirtyRegionTemp;
    private DirtyRegionPool dirtyRegionPool;
    private DirtyRegionContainer dirtyRegionContainer;
    private Affine3D tx;
    private Affine3D scaleTx;
    private GeneralTransform3D viewProjTx;
    private GeneralTransform3D projTx;
    private RTTexture sceneBuffer;

    protected ViewPainter(GlassScene gs) {
        this.sceneState = gs.getSceneState();
        if (this.sceneState == null) {
            throw new NullPointerException("Scene state is null");
        }
        if (PrismSettings.dirtyOptsEnabled) {
            this.tx = new Affine3D();
            this.viewProjTx = new GeneralTransform3D();
            this.projTx = new GeneralTransform3D();
            this.scaleTx = new Affine3D();
            this.clip = new RectBounds();
            this.dirtyRect = new Rectangle();
            this.dirtyRegionTemp = new RectBounds();
            this.dirtyRegionPool = new DirtyRegionPool(PrismSettings.dirtyRegionCount);
            this.dirtyRegionContainer = this.dirtyRegionPool.checkOut();
        }
    }

    protected final void setRoot(NGNode node) {
        this.root = node;
    }

    protected final void setOverlayRoot(NGNode node) {
        this.overlayRoot = node;
    }

    private void adjustPerspective(NGCamera camera) {
        assert (PrismSettings.dirtyOptsEnabled);
        if (camera instanceof NGPerspectiveCamera) {
            this.scaleTx.setToScale((double)this.width / 2.0, (double)(-this.height) / 2.0, 1.0);
            this.scaleTx.translate(1.0, -1.0);
            this.projTx.mul(this.scaleTx);
            this.viewProjTx = camera.getProjViewTx(this.viewProjTx);
            this.projTx.mul(this.viewProjTx);
        }
    }

    protected void paintImpl(Graphics backBufferGraphics) {
        int i;
        int dirtyRegionSize;
        boolean showDirtyOpts;
        if (this.width <= 0 || this.height <= 0 || backBufferGraphics == null) {
            this.root.renderForcedContent(backBufferGraphics);
            return;
        }
        Graphics g = backBufferGraphics;
        float pixelScaleX = this.getPixelScaleFactorX();
        float pixelScaleY = this.getPixelScaleFactorY();
        g.setPixelScaleFactors(pixelScaleX, pixelScaleY);
        boolean renderEverything = this.overlayRoot != null || this.freshBackBuffer || this.sceneState.getScene().isEntireSceneDirty() || this.sceneState.getScene().getDepthBuffer() || !PrismSettings.dirtyOptsEnabled;
        boolean bl = showDirtyOpts = PrismSettings.showDirtyRegions || PrismSettings.showOverdraw;
        if (showDirtyOpts && !this.sceneState.getScene().getDepthBuffer()) {
            int bufferWidth = (int)Math.ceil((float)this.width * pixelScaleX);
            int bufferHeight = (int)Math.ceil((float)this.height * pixelScaleY);
            if (this.sceneBuffer != null) {
                this.sceneBuffer.lock();
                if (this.sceneBuffer.isSurfaceLost() || bufferWidth != this.sceneBuffer.getContentWidth() || bufferHeight != this.sceneBuffer.getContentHeight()) {
                    this.sceneBuffer.unlock();
                    this.sceneBuffer.dispose();
                    this.sceneBuffer = null;
                }
            }
            if (this.sceneBuffer == null) {
                this.sceneBuffer = g.getResourceFactory().createRTTexture(bufferWidth, bufferHeight, Texture.WrapMode.CLAMP_TO_ZERO, false);
                renderEverything = true;
            }
            this.sceneBuffer.contentsUseful();
            g = this.sceneBuffer.createGraphics();
            g.setPixelScaleFactors(pixelScaleX, pixelScaleY);
            g.scale(pixelScaleX, pixelScaleY);
        } else if (this.sceneBuffer != null) {
            this.sceneBuffer.dispose();
            this.sceneBuffer = null;
        }
        int status = -1;
        if (!renderEverything) {
            if (PulseLogger.PULSE_LOGGING_ENABLED) {
                PulseLogger.newPhase((String)"Dirty Opts Computed");
            }
            this.clip.setBounds(0.0f, 0.0f, this.width, this.height);
            this.dirtyRegionTemp.makeEmpty();
            this.dirtyRegionContainer.reset();
            this.tx.setToIdentity();
            this.projTx.setIdentity();
            this.adjustPerspective(this.sceneState.getCamera());
            status = this.root.accumulateDirtyRegions(this.clip, this.dirtyRegionTemp, this.dirtyRegionPool, this.dirtyRegionContainer, this.tx, this.projTx);
            this.dirtyRegionContainer.roundOut();
            if (status == 1) {
                this.root.doPreCulling(this.dirtyRegionContainer, this.tx, this.projTx);
            }
        }
        int n = dirtyRegionSize = status == 1 ? this.dirtyRegionContainer.size() : 0;
        if (dirtyRegionSize > 0) {
            int i2;
            g.setHasPreCullingBits(true);
            if (PulseLogger.PULSE_LOGGING_ENABLED) {
                PulseLogger.newPhase((String)"Render Roots Discovered");
            }
            for (i2 = 0; i2 < dirtyRegionSize; ++i2) {
                NodePath path = ViewPainter.getRootPath(i2);
                path.clear();
                this.root.getRenderRoot(ViewPainter.getRootPath(i2), this.dirtyRegionContainer.getDirtyRegion(i2), i2, this.tx, this.projTx);
            }
            if (PulseLogger.PULSE_LOGGING_ENABLED) {
                PulseLogger.addMessage((String)(dirtyRegionSize + " different dirty regions to render"));
                for (i2 = 0; i2 < dirtyRegionSize; ++i2) {
                    PulseLogger.addMessage((String)("Dirty Region " + i2 + ": " + this.dirtyRegionContainer.getDirtyRegion(i2)));
                    PulseLogger.addMessage((String)("Render Root Path " + i2 + ": " + ViewPainter.getRootPath(i2)));
                }
            }
            if (PulseLogger.PULSE_LOGGING_ENABLED && PrismSettings.printRenderGraph) {
                StringBuilder s = new StringBuilder();
                ArrayList<NGNode> roots = new ArrayList<NGNode>();
                for (int i3 = 0; i3 < dirtyRegionSize; ++i3) {
                    NodePath nodePath;
                    RectBounds dirtyRegion = this.dirtyRegionContainer.getDirtyRegion(i3);
                    if (!(dirtyRegion.getWidth() > 0.0f) || !(dirtyRegion.getHeight() > 0.0f) || (nodePath = ViewPainter.getRootPath(i3)).isEmpty()) continue;
                    roots.add(nodePath.last());
                }
                this.root.printDirtyOpts(s, roots);
                PulseLogger.addMessage((String)s.toString());
            }
            for (i = 0; i < dirtyRegionSize; ++i) {
                int y0;
                int x0;
                RectBounds dirtyRegion = this.dirtyRegionContainer.getDirtyRegion(i);
                if (!(dirtyRegion.getWidth() > 0.0f) || !(dirtyRegion.getHeight() > 0.0f)) continue;
                this.dirtyRect.x = x0 = (int)Math.floor(dirtyRegion.getMinX() * pixelScaleX);
                this.dirtyRect.y = y0 = (int)Math.floor(dirtyRegion.getMinY() * pixelScaleY);
                this.dirtyRect.width = (int)Math.ceil(dirtyRegion.getMaxX() * pixelScaleX) - x0;
                this.dirtyRect.height = (int)Math.ceil(dirtyRegion.getMaxY() * pixelScaleY) - y0;
                g.setClipRect(this.dirtyRect);
                g.setClipRectIndex(i);
                this.doPaint(g, ViewPainter.getRootPath(i));
            }
        } else {
            g.setHasPreCullingBits(false);
            g.setClipRect(null);
            this.doPaint(g, null);
        }
        this.root.renderForcedContent(g);
        if (this.overlayRoot != null) {
            this.overlayRoot.render(g);
        }
        if (showDirtyOpts) {
            if (this.sceneBuffer != null) {
                g.sync();
                backBufferGraphics.clear();
                backBufferGraphics.drawTexture(this.sceneBuffer, 0.0f, 0.0f, this.width, this.height, this.sceneBuffer.getContentX(), this.sceneBuffer.getContentY(), this.sceneBuffer.getContentX() + this.sceneBuffer.getContentWidth(), this.sceneBuffer.getContentY() + this.sceneBuffer.getContentHeight());
                this.sceneBuffer.unlock();
            }
            if (PrismSettings.showOverdraw) {
                if (dirtyRegionSize > 0) {
                    for (i = 0; i < dirtyRegionSize; ++i) {
                        Rectangle clip = new Rectangle(this.dirtyRegionContainer.getDirtyRegion(i));
                        backBufferGraphics.setClipRectIndex(i);
                        this.paintOverdraw(backBufferGraphics, clip);
                        backBufferGraphics.setPaint(new Color(1.0f, 0.0f, 0.0f, 0.3f));
                        backBufferGraphics.drawRect(clip.x, clip.y, clip.width, clip.height);
                    }
                } else {
                    Rectangle clip = new Rectangle(0, 0, this.width, this.height);
                    assert (backBufferGraphics.getClipRectIndex() == 0);
                    this.paintOverdraw(backBufferGraphics, clip);
                    backBufferGraphics.setPaint(new Color(1.0f, 0.0f, 0.0f, 0.3f));
                    backBufferGraphics.drawRect(clip.x, clip.y, clip.width, clip.height);
                }
            } else if (dirtyRegionSize > 0) {
                backBufferGraphics.setPaint(new Color(1.0f, 0.0f, 0.0f, 0.3f));
                for (i = 0; i < dirtyRegionSize; ++i) {
                    RectBounds reg = this.dirtyRegionContainer.getDirtyRegion(i);
                    backBufferGraphics.fillRect(reg.getMinX(), reg.getMinY(), reg.getWidth(), reg.getHeight());
                }
            } else {
                backBufferGraphics.setPaint(new Color(1.0f, 0.0f, 0.0f, 0.3f));
                backBufferGraphics.fillRect(0.0f, 0.0f, this.width, this.height);
            }
            this.root.clearPainted();
        }
    }

    private void paintOverdraw(Graphics g, Rectangle clip) {
        int[] pixels = new int[clip.width * clip.height];
        this.root.drawDirtyOpts(BaseTransform.IDENTITY_TRANSFORM, this.projTx, clip, pixels, g.getClipRectIndex());
        Image image = Image.fromIntArgbPreData(pixels, clip.width, clip.height);
        Texture texture = this.factory.getCachedTexture(image, Texture.WrapMode.CLAMP_TO_EDGE);
        g.drawTexture(texture, clip.x, clip.y, clip.x + clip.width, clip.y + clip.height, 0.0f, 0.0f, clip.width, clip.height);
        texture.unlock();
    }

    private static NodePath getRootPath(int i) {
        if (ROOT_PATHS[i] == null) {
            ViewPainter.ROOT_PATHS[i] = new NodePath();
        }
        return ROOT_PATHS[i];
    }

    protected void disposePresentable() {
        if (this.presentable instanceof GraphicsResource) {
            ((GraphicsResource)((Object)this.presentable)).dispose();
        }
        this.presentable = null;
    }

    protected boolean validateStageGraphics() {
        if (!this.sceneState.isValid()) {
            return false;
        }
        this.width = this.viewWidth = this.sceneState.getWidth();
        this.height = this.viewHeight = this.sceneState.getHeight();
        return this.sceneState.isWindowVisible() && !this.sceneState.isWindowMinimized();
    }

    protected float getPixelScaleFactorX() {
        return this.presentable == null ? 1.0f : this.presentable.getPixelScaleFactorX();
    }

    protected float getPixelScaleFactorY() {
        return this.presentable == null ? 1.0f : this.presentable.getPixelScaleFactorY();
    }

    private void doPaint(Graphics g, NodePath renderRootPath) {
        Paint curPaint;
        if (renderRootPath != null) {
            if (renderRootPath.isEmpty()) {
                this.root.clearDirtyTree();
                return;
            }
            assert (renderRootPath.getCurrentNode() == this.root);
        }
        if (PulseLogger.PULSE_LOGGING_ENABLED) {
            PulseLogger.newPhase((String)"Painting");
        }
        GlassScene scene = this.sceneState.getScene();
        scene.clearEntireSceneDirty();
        g.setLights(scene.getLights());
        g.setDepthBuffer(scene.getDepthBuffer());
        Color clearColor = this.sceneState.getClearColor();
        if (clearColor != null) {
            g.clear(clearColor);
        }
        if ((curPaint = this.sceneState.getCurrentPaint()) != null) {
            if (curPaint.getType() != Paint.Type.COLOR) {
                g.getRenderTarget().setOpaque(curPaint.isOpaque());
            }
            g.setPaint(curPaint);
            g.fillQuad(0.0f, 0.0f, this.width, this.height);
        }
        g.setCamera(this.sceneState.getCamera());
        g.setRenderRoot(renderRootPath);
        this.root.render(g);
    }
}

