/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javafx.tk.quantum;

import com.sun.javafx.tk.Toolkit;
import com.sun.javafx.tk.quantum.PerformanceLogger;
import com.sun.prism.impl.PrismSettings;
import java.security.AccessController;
import java.security.PrivilegedAction;

abstract class PerformanceTrackerHelper {
    private static final PerformanceTrackerHelper instance = PerformanceTrackerHelper.createInstance();

    public static PerformanceTrackerHelper getInstance() {
        return instance;
    }

    private PerformanceTrackerHelper() {
    }

    private static PerformanceTrackerHelper createInstance() {
        PerformanceTrackerHelper trackerImpl = AccessController.doPrivileged(new PrivilegedAction<PerformanceTrackerHelper>(){

            @Override
            public PerformanceTrackerHelper run() {
                try {
                    if (PrismSettings.perfLog != null) {
                        final PerformanceTrackerDefaultImpl trackerImpl = new PerformanceTrackerDefaultImpl();
                        if (PrismSettings.perfLogExitFlush) {
                            Runtime.getRuntime().addShutdownHook(new Thread(){

                                @Override
                                public void run() {
                                    trackerImpl.outputLog();
                                }
                            });
                        }
                        return trackerImpl;
                    }
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
                return null;
            }
        });
        if (trackerImpl == null) {
            trackerImpl = new PerformanceTrackerDummyImpl();
        }
        return trackerImpl;
    }

    public abstract void logEvent(String var1);

    public abstract void outputLog();

    public abstract boolean isPerfLoggingEnabled();

    public final long nanoTime() {
        return Toolkit.getToolkit().getMasterTimer().nanos();
    }

    private static final class PerformanceTrackerDummyImpl
    extends PerformanceTrackerHelper {
        private PerformanceTrackerDummyImpl() {
        }

        @Override
        public void logEvent(String s) {
        }

        @Override
        public void outputLog() {
        }

        @Override
        public boolean isPerfLoggingEnabled() {
            return false;
        }
    }

    private static final class PerformanceTrackerDefaultImpl
    extends PerformanceTrackerHelper {
        private long firstTime;
        private long lastTime;

        private PerformanceTrackerDefaultImpl() {
        }

        @Override
        public void logEvent(String s) {
            long time = System.currentTimeMillis();
            if (this.firstTime == 0L) {
                this.firstTime = time;
            }
            PerformanceLogger.setTime("JavaFX> " + s + " (" + (time - this.firstTime) + "ms total, " + (time - this.lastTime) + "ms)");
            this.lastTime = time;
        }

        @Override
        public void outputLog() {
            this.logLaunchTime();
            PerformanceLogger.outputLog();
        }

        @Override
        public boolean isPerfLoggingEnabled() {
            return true;
        }

        private void logLaunchTime() {
            try {
                String launchTimeString;
                if (PerformanceLogger.getStartTime() <= 0L && (launchTimeString = AccessController.doPrivileged(() -> System.getProperty("launchTime"))) != null && !launchTimeString.equals("")) {
                    long launchTime = Long.parseLong(launchTimeString);
                    PerformanceLogger.setStartTime("LaunchTime", launchTime);
                }
            }
            catch (Throwable t) {
                t.printStackTrace();
            }
        }
    }
}

