/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javafx.tk.quantum;

import com.sun.glass.ui.Application;
import com.sun.glass.ui.View;
import com.sun.glass.ui.Window;
import com.sun.javafx.stage.WindowHelper;
import com.sun.javafx.tk.AppletWindow;
import com.sun.javafx.tk.TKStage;
import com.sun.javafx.tk.quantum.QuantumToolkit;
import com.sun.javafx.tk.quantum.WindowStage;
import java.lang.ref.WeakReference;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;
import javafx.stage.Stage;

class GlassAppletWindow
implements AppletWindow {
    private final Window glassWindow;
    private WeakReference<Stage> topStage;
    private String serverName;

    GlassAppletWindow(long nativeParent, String serverName) {
        if (0L == nativeParent) {
            if (serverName != null) {
                throw new RuntimeException("GlassAppletWindow constructor used incorrectly.");
            }
            this.glassWindow = Application.GetApplication().createWindow(null, 0);
        } else {
            this.serverName = serverName;
            this.glassWindow = Application.GetApplication().createWindow(nativeParent);
        }
        this.glassWindow.setAppletMode(true);
    }

    Window getGlassWindow() {
        return this.glassWindow;
    }

    @Override
    public void setBackgroundColor(int color) {
        Application.invokeLater(() -> {
            float RR = (float)(color >> 16 & 0xFF) / 255.0f;
            float GG = (float)(color >> 8 & 0xFF) / 255.0f;
            float BB = (float)(color & 0xFF) / 255.0f;
            this.glassWindow.setBackground(RR, GG, BB);
        });
    }

    @Override
    public void setForegroundColor(int color) {
    }

    @Override
    public void setVisible(boolean state) {
        Application.invokeLater(() -> this.glassWindow.setVisible(state));
    }

    @Override
    public void setSize(int width, int height) {
        Application.invokeLater(() -> this.glassWindow.setSize(width, height));
    }

    @Override
    public int getWidth() {
        AtomicInteger width = new AtomicInteger(0);
        Application.invokeAndWait(() -> width.set(this.glassWindow.getWidth()));
        return width.get();
    }

    @Override
    public int getHeight() {
        AtomicInteger height = new AtomicInteger(0);
        Application.invokeAndWait(() -> height.set(this.glassWindow.getHeight()));
        return height.get();
    }

    @Override
    public void setPosition(int x, int y) {
        Application.invokeLater(() -> this.glassWindow.setPosition(x, y));
    }

    @Override
    public int getPositionX() {
        AtomicInteger x = new AtomicInteger(0);
        Application.invokeAndWait(() -> x.set(this.glassWindow.getX()));
        return x.get();
    }

    @Override
    public int getPositionY() {
        AtomicInteger y = new AtomicInteger(0);
        Application.invokeAndWait(() -> y.set(this.glassWindow.getY()));
        return y.get();
    }

    @Override
    public float getPlatformScaleX() {
        AtomicReference<Float> pScale = new AtomicReference<Float>(Float.valueOf(0.0f));
        Application.invokeAndWait(() -> pScale.set(Float.valueOf(this.glassWindow.getPlatformScaleX())));
        return pScale.get().floatValue();
    }

    @Override
    public float getPlatformScaleY() {
        AtomicReference<Float> pScale = new AtomicReference<Float>(Float.valueOf(0.0f));
        Application.invokeAndWait(() -> pScale.set(Float.valueOf(this.glassWindow.getPlatformScaleY())));
        return pScale.get().floatValue();
    }

    void dispose() {
        QuantumToolkit.runWithRenderLock(() -> {
            this.glassWindow.close();
            return null;
        });
    }

    @Override
    public void setStageOnTop(Stage topStage) {
        this.topStage = null != topStage ? new WeakReference<Stage>(topStage) : null;
    }

    @Override
    public int getRemoteLayerId() {
        AtomicInteger id = new AtomicInteger(-1);
        Application.invokeAndWait(() -> {
            View view = this.glassWindow.getView();
            if (view != null) {
                id.set(view.getNativeRemoteLayerId(this.serverName));
            }
        });
        return id.get();
    }

    @Override
    public void dispatchEvent(Map eventInfo) {
        Application.invokeAndWait(() -> this.glassWindow.dispatchNpapiEvent(eventInfo));
    }

    void assertStageOrder() {
        Window pw;
        TKStage tsp;
        Stage ts;
        if (null != this.topStage && null != (ts = (Stage)this.topStage.get()) && (tsp = WindowHelper.getPeer(ts)) instanceof WindowStage && ((WindowStage)tsp).isVisible() && null != (pw = ((WindowStage)tsp).getPlatformWindow())) {
            pw.toFront();
        }
    }
}

