/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javafx.tk.quantum;

import com.sun.javafx.embed.AbstractEvents;
import com.sun.javafx.embed.EmbeddedStageInterface;
import com.sun.javafx.embed.HostInterface;
import com.sun.javafx.tk.TKScene;
import com.sun.javafx.tk.Toolkit;
import com.sun.javafx.tk.quantum.EmbeddedScene;
import com.sun.javafx.tk.quantum.GlassScene;
import com.sun.javafx.tk.quantum.GlassStage;
import com.sun.javafx.tk.quantum.QuantumToolkit;
import java.security.AccessControlContext;
import java.security.AccessController;
import java.util.List;
import javafx.application.Platform;

final class EmbeddedStage
extends GlassStage
implements EmbeddedStageInterface {
    private HostInterface host;

    public EmbeddedStage(HostInterface host) {
        this.host = host;
    }

    @Override
    public TKScene createTKScene(boolean depthBuffer, boolean msaa, AccessControlContext acc) {
        EmbeddedScene scene = new EmbeddedScene(this.host, depthBuffer, msaa);
        scene.setSecurityContext(acc);
        return scene;
    }

    @Override
    public void setScene(TKScene scene) {
        if (scene != null) assert (scene instanceof EmbeddedScene);
        super.setScene(scene);
    }

    @Override
    public void setBounds(float x, float y, boolean xSet, boolean ySet, float w, float h, float cw, float ch, float xGravity, float yGravity, float renderScaleX, float renderScaleY) {
        float newH;
        if (QuantumToolkit.verbose) {
            System.err.println("EmbeddedStage.setBounds: x=" + x + " y=" + y + " xSet=" + xSet + " ySet=" + ySet + " w=" + w + " h= cw=" + cw + " ch=" + ch);
        }
        float newW = w > 0.0f ? w : cw;
        float f = newH = h > 0.0f ? h : ch;
        if (newW > 0.0f && newH > 0.0f) {
            this.host.setPreferredSize((int)newW, (int)newH);
        }
        GlassScene scene = this.getScene();
        if ((renderScaleX > 0.0f || renderScaleY > 0.0f) && scene instanceof EmbeddedScene) {
            EmbeddedScene escene = (EmbeddedScene)scene;
            if ((double)renderScaleX <= 0.0) {
                renderScaleX = escene.getRenderScaleX();
            }
            if ((double)renderScaleY <= 0.0) {
                renderScaleY = escene.getRenderScaleY();
            }
            escene.setPixelScaleFactors(renderScaleX, renderScaleY);
        }
    }

    @Override
    public float getPlatformScaleX() {
        return 1.0f;
    }

    @Override
    public float getPlatformScaleY() {
        return 1.0f;
    }

    @Override
    public float getOutputScaleX() {
        GlassScene scene = this.getScene();
        if (scene instanceof EmbeddedScene) {
            return ((EmbeddedScene)scene).getRenderScaleX();
        }
        return 1.0f;
    }

    @Override
    public float getOutputScaleY() {
        GlassScene scene = this.getScene();
        if (scene instanceof EmbeddedScene) {
            return ((EmbeddedScene)scene).getRenderScaleY();
        }
        return 1.0f;
    }

    @Override
    public void setMinimumSize(int minWidth, int minHeight) {
    }

    @Override
    public void setMaximumSize(int maxWidth, int maxHeight) {
    }

    @Override
    protected void setPlatformEnabled(boolean enabled) {
        super.setPlatformEnabled(enabled);
        this.host.setEnabled(enabled);
    }

    @Override
    public void setIcons(List icons) {
        if (QuantumToolkit.verbose) {
            System.err.println("EmbeddedStage.setIcons");
        }
    }

    @Override
    public void setTitle(String title) {
        if (QuantumToolkit.verbose) {
            System.err.println("EmbeddedStage.setTitle " + title);
        }
    }

    @Override
    public void setVisible(boolean visible) {
        this.host.setEmbeddedStage(visible ? this : null);
        super.setVisible(visible);
    }

    @Override
    public void setOpacity(float opacity) {
    }

    @Override
    public void setIconified(boolean iconified) {
        if (QuantumToolkit.verbose) {
            System.err.println("EmbeddedScene.setIconified " + iconified);
        }
    }

    @Override
    public void setMaximized(boolean maximized) {
        if (QuantumToolkit.verbose) {
            System.err.println("EmbeddedScene.setMaximized " + maximized);
        }
    }

    @Override
    public void setAlwaysOnTop(boolean alwaysOnTop) {
        if (QuantumToolkit.verbose) {
            System.err.println("EmbeddedScene.setAlwaysOnTop " + alwaysOnTop);
        }
    }

    @Override
    public void setResizable(boolean resizable) {
        if (QuantumToolkit.verbose) {
            System.err.println("EmbeddedStage.setResizable " + resizable);
        }
    }

    @Override
    public void setFullScreen(boolean fullScreen) {
        if (QuantumToolkit.verbose) {
            System.err.println("EmbeddedStage.setFullScreen " + fullScreen);
        }
    }

    @Override
    public void requestFocus() {
        if (!this.host.requestFocus()) {
            return;
        }
        super.requestFocus();
    }

    @Override
    public void toBack() {
        if (QuantumToolkit.verbose) {
            System.err.println("EmbeddedStage.toBack");
        }
    }

    @Override
    public void toFront() {
        if (QuantumToolkit.verbose) {
            System.err.println("EmbeddedStage.toFront");
        }
    }

    @Override
    public boolean grabFocus() {
        return this.host.grabFocus();
    }

    @Override
    public void ungrabFocus() {
        this.host.ungrabFocus();
    }

    private void notifyStageListener(Runnable r) {
        AccessControlContext acc = this.getAccessControlContext();
        AccessController.doPrivileged(() -> {
            r.run();
            return null;
        }, acc);
    }

    private void notifyStageListenerLater(Runnable r) {
        Platform.runLater(() -> this.notifyStageListener(r));
    }

    @Override
    public void setLocation(int x, int y) {
        Runnable r = () -> {
            if (this.stageListener != null) {
                this.stageListener.changedLocation(x, y);
            }
        };
        if (Toolkit.getToolkit().isFxUserThread()) {
            this.notifyStageListener(r);
        } else {
            this.notifyStageListenerLater(r);
        }
    }

    @Override
    public void setSize(int width, int height) {
        Runnable r = () -> {
            if (this.stageListener != null) {
                this.stageListener.changedSize(width, height);
            }
        };
        if (Toolkit.getToolkit().isFxUserThread()) {
            this.notifyStageListener(r);
        } else {
            this.notifyStageListenerLater(r);
        }
    }

    @Override
    public void setFocused(boolean focused, int focusCause) {
        Runnable r = () -> {
            if (this.stageListener != null) {
                this.stageListener.changedFocused(focused, AbstractEvents.focusCauseToPeerFocusCause(focusCause));
            }
        };
        if (Toolkit.getToolkit().isFxUserThread()) {
            this.notifyStageListener(r);
        } else {
            this.notifyStageListenerLater(r);
        }
    }

    @Override
    public void focusUngrab() {
        Runnable r = () -> {
            if (this.stageListener != null) {
                this.stageListener.focusUngrab();
            }
        };
        if (Toolkit.getToolkit().isFxUserThread()) {
            this.notifyStageListener(r);
        } else {
            this.notifyStageListenerLater(r);
        }
    }

    @Override
    public void requestInput(String text, int type, double width, double height, double Mxx, double Mxy, double Mxz, double Mxt, double Myx, double Myy, double Myz, double Myt, double Mzx, double Mzy, double Mzz, double Mzt) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public void releaseInput() {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public void setRTL(boolean b) {
    }

    @Override
    public void setEnabled(boolean enabled) {
    }

    @Override
    public long getRawHandle() {
        return 0L;
    }
}

