/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javafx.scene.shape;

import com.sun.javafx.geom.BaseBounds;
import com.sun.javafx.geom.PickRay;
import com.sun.javafx.geom.transform.BaseTransform;
import com.sun.javafx.scene.input.PickResultChooser;
import com.sun.javafx.scene.shape.Shape3DHelper;
import com.sun.javafx.sg.prism.NGNode;
import com.sun.javafx.util.Utils;
import javafx.scene.Node;
import javafx.scene.shape.Box;

public class BoxHelper
extends Shape3DHelper {
    private static final BoxHelper theInstance = new BoxHelper();
    private static BoxAccessor boxAccessor;

    private static BoxHelper getInstance() {
        return theInstance;
    }

    public static void initHelper(Box box) {
        BoxHelper.setHelper(box, BoxHelper.getInstance());
    }

    @Override
    protected NGNode createPeerImpl(Node node) {
        return boxAccessor.doCreatePeer(node);
    }

    @Override
    protected void updatePeerImpl(Node node) {
        super.updatePeerImpl(node);
        boxAccessor.doUpdatePeer(node);
    }

    @Override
    protected BaseBounds computeGeomBoundsImpl(Node node, BaseBounds bounds, BaseTransform tx) {
        return boxAccessor.doComputeGeomBounds(node, bounds, tx);
    }

    @Override
    protected boolean computeContainsImpl(Node node, double localX, double localY) {
        return boxAccessor.doComputeContains(node, localX, localY);
    }

    @Override
    protected boolean computeIntersectsImpl(Node node, PickRay pickRay, PickResultChooser pickResult) {
        return boxAccessor.doComputeIntersects(node, pickRay, pickResult);
    }

    public static void setBoxAccessor(BoxAccessor newAccessor) {
        if (boxAccessor != null) {
            throw new IllegalStateException();
        }
        boxAccessor = newAccessor;
    }

    static {
        Utils.forceInit(Box.class);
    }

    public static interface BoxAccessor {
        public NGNode doCreatePeer(Node var1);

        public void doUpdatePeer(Node var1);

        public BaseBounds doComputeGeomBounds(Node var1, BaseBounds var2, BaseTransform var3);

        public boolean doComputeContains(Node var1, double var2, double var4);

        public boolean doComputeIntersects(Node var1, PickRay var2, PickResultChooser var3);
    }
}

