/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javafx.scene.layout.region;

import com.sun.javafx.scene.layout.region.RepeatStruct;
import javafx.css.ParsedValue;
import javafx.css.StyleConverter;
import javafx.css.converter.EnumConverter;
import javafx.scene.layout.BackgroundRepeat;
import javafx.scene.text.Font;

public final class RepeatStructConverter
extends StyleConverter<ParsedValue<String, BackgroundRepeat>[][], RepeatStruct[]> {
    private static final RepeatStructConverter REPEAT_STRUCT_CONVERTER = new RepeatStructConverter();
    private final EnumConverter<BackgroundRepeat> repeatConverter = new EnumConverter<BackgroundRepeat>(BackgroundRepeat.class);

    public static RepeatStructConverter getInstance() {
        return REPEAT_STRUCT_CONVERTER;
    }

    private RepeatStructConverter() {
    }

    @Override
    public RepeatStruct[] convert(ParsedValue<ParsedValue<String, BackgroundRepeat>[][], RepeatStruct[]> value, Font font) {
        ParsedValue<String, BackgroundRepeat>[][] layers = value.getValue();
        RepeatStruct[] backgroundRepeat = new RepeatStruct[layers.length];
        for (int l = 0; l < layers.length; ++l) {
            ParsedValue<String, BackgroundRepeat>[] repeats = layers[l];
            BackgroundRepeat horizontal = (BackgroundRepeat)((Object)this.repeatConverter.convert((ParsedValue)repeats[0], (Font)null));
            BackgroundRepeat vertical = (BackgroundRepeat)((Object)this.repeatConverter.convert((ParsedValue)repeats[1], (Font)null));
            backgroundRepeat[l] = new RepeatStruct(horizontal, vertical);
        }
        return backgroundRepeat;
    }

    public String toString() {
        return "RepeatStructConverter";
    }
}

