/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javafx.geom;

import com.sun.javafx.geom.FlatteningPathIterator;
import com.sun.javafx.geom.IllegalPathStateException;
import com.sun.javafx.geom.PathConsumer2D;
import com.sun.javafx.geom.PathIterator;
import com.sun.javafx.geom.Point2D;
import com.sun.javafx.geom.RectBounds;
import com.sun.javafx.geom.Rectangle;
import com.sun.javafx.geom.Shape;
import com.sun.javafx.geom.transform.BaseTransform;
import java.util.Arrays;

public class Path2D
extends Shape
implements PathConsumer2D {
    static final int[] curvecoords = new int[]{2, 2, 4, 6, 0};
    public static final int WIND_EVEN_ODD = 0;
    public static final int WIND_NON_ZERO = 1;
    private static final byte SEG_MOVETO = 0;
    private static final byte SEG_LINETO = 1;
    private static final byte SEG_QUADTO = 2;
    private static final byte SEG_CUBICTO = 3;
    private static final byte SEG_CLOSE = 4;
    byte[] pointTypes;
    int numTypes;
    int numCoords;
    int windingRule;
    static final int INIT_SIZE = 20;
    static final int EXPAND_MAX = 500;
    static final int EXPAND_MAX_COORDS = 1000;
    float[] floatCoords;
    float moveX;
    float moveY;
    float prevX;
    float prevY;
    float currX;
    float currY;

    public Path2D() {
        this(1, 20);
    }

    public Path2D(int rule) {
        this(rule, 20);
    }

    public Path2D(int rule, int initialCapacity) {
        this.setWindingRule(rule);
        this.pointTypes = new byte[initialCapacity];
        this.floatCoords = new float[initialCapacity * 2];
    }

    public Path2D(Shape s) {
        this(s, null);
    }

    public Path2D(Shape s, BaseTransform tx) {
        if (s instanceof Path2D) {
            Path2D p2d = (Path2D)s;
            this.setWindingRule(p2d.windingRule);
            this.numTypes = p2d.numTypes;
            this.pointTypes = Arrays.copyOf(p2d.pointTypes, this.numTypes);
            this.numCoords = p2d.numCoords;
            if (tx == null || tx.isIdentity()) {
                this.floatCoords = Arrays.copyOf(p2d.floatCoords, this.numCoords);
                this.moveX = p2d.moveX;
                this.moveY = p2d.moveY;
                this.prevX = p2d.prevX;
                this.prevY = p2d.prevY;
                this.currX = p2d.currX;
                this.currY = p2d.currY;
            } else {
                this.floatCoords = new float[this.numCoords + 6];
                tx.transform(p2d.floatCoords, 0, this.floatCoords, 0, this.numCoords / 2);
                this.floatCoords[this.numCoords + 0] = this.moveX;
                this.floatCoords[this.numCoords + 1] = this.moveY;
                this.floatCoords[this.numCoords + 2] = this.prevX;
                this.floatCoords[this.numCoords + 3] = this.prevY;
                this.floatCoords[this.numCoords + 4] = this.currX;
                this.floatCoords[this.numCoords + 5] = this.currY;
                tx.transform(this.floatCoords, this.numCoords, this.floatCoords, this.numCoords, 3);
                this.moveX = this.floatCoords[this.numCoords + 0];
                this.moveY = this.floatCoords[this.numCoords + 1];
                this.prevX = this.floatCoords[this.numCoords + 2];
                this.prevY = this.floatCoords[this.numCoords + 3];
                this.currX = this.floatCoords[this.numCoords + 4];
                this.currY = this.floatCoords[this.numCoords + 5];
            }
        } else {
            PathIterator pi = s.getPathIterator(tx);
            this.setWindingRule(pi.getWindingRule());
            this.pointTypes = new byte[20];
            this.floatCoords = new float[40];
            this.append(pi, false);
        }
    }

    public Path2D(int windingRule, byte[] pointTypes, int numTypes, float[] pointCoords, int numCoords) {
        this.windingRule = windingRule;
        this.pointTypes = pointTypes;
        this.numTypes = numTypes;
        this.floatCoords = pointCoords;
        this.numCoords = numCoords;
    }

    Point2D getPoint(int coordindex) {
        return new Point2D(this.floatCoords[coordindex], this.floatCoords[coordindex + 1]);
    }

    private boolean close(int ix, float fx, float tolerance) {
        return Math.abs((float)ix - fx) <= tolerance;
    }

    public boolean checkAndGetIntRect(Rectangle retrect, float tolerance) {
        if (this.numTypes == 5) {
            if (this.pointTypes[4] != 1 && this.pointTypes[4] != 4) {
                return false;
            }
        } else if (this.numTypes == 6) {
            if (this.pointTypes[4] != 1) {
                return false;
            }
            if (this.pointTypes[5] != 4) {
                return false;
            }
        } else if (this.numTypes != 4) {
            return false;
        }
        if (this.pointTypes[0] != 0) {
            return false;
        }
        if (this.pointTypes[1] != 1) {
            return false;
        }
        if (this.pointTypes[2] != 1) {
            return false;
        }
        if (this.pointTypes[3] != 1) {
            return false;
        }
        int x0 = (int)(this.floatCoords[0] + 0.5f);
        int y0 = (int)(this.floatCoords[1] + 0.5f);
        if (!this.close(x0, this.floatCoords[0], tolerance)) {
            return false;
        }
        if (!this.close(y0, this.floatCoords[1], tolerance)) {
            return false;
        }
        int x1 = (int)(this.floatCoords[2] + 0.5f);
        int y1 = (int)(this.floatCoords[3] + 0.5f);
        if (!this.close(x1, this.floatCoords[2], tolerance)) {
            return false;
        }
        if (!this.close(y1, this.floatCoords[3], tolerance)) {
            return false;
        }
        int x2 = (int)(this.floatCoords[4] + 0.5f);
        int y2 = (int)(this.floatCoords[5] + 0.5f);
        if (!this.close(x2, this.floatCoords[4], tolerance)) {
            return false;
        }
        if (!this.close(y2, this.floatCoords[5], tolerance)) {
            return false;
        }
        int x3 = (int)(this.floatCoords[6] + 0.5f);
        int y3 = (int)(this.floatCoords[7] + 0.5f);
        if (!this.close(x3, this.floatCoords[6], tolerance)) {
            return false;
        }
        if (!this.close(y3, this.floatCoords[7], tolerance)) {
            return false;
        }
        if (this.numTypes > 4 && this.pointTypes[4] == 1) {
            if (!this.close(x0, this.floatCoords[8], tolerance)) {
                return false;
            }
            if (!this.close(y0, this.floatCoords[9], tolerance)) {
                return false;
            }
        }
        if (x0 == x1 && x2 == x3 && y0 == y3 && y1 == y2 || y0 == y1 && y2 == y3 && x0 == x3 && x1 == x2) {
            int h;
            int y;
            int w;
            int x;
            if (x2 < x0) {
                x = x2;
                w = x0 - x2;
            } else {
                x = x0;
                w = x2 - x0;
            }
            if (y2 < y0) {
                y = y2;
                h = y0 - y2;
            } else {
                y = y0;
                h = y2 - y0;
            }
            if (w < 0) {
                return false;
            }
            if (h < 0) {
                return false;
            }
            if (retrect != null) {
                retrect.setBounds(x, y, w, h);
            }
            return true;
        }
        return false;
    }

    void needRoom(boolean needMove, int newCoords) {
        if (needMove && this.numTypes == 0) {
            throw new IllegalPathStateException("missing initial moveto in path definition");
        }
        int size = this.pointTypes.length;
        if (size == 0) {
            this.pointTypes = new byte[2];
        } else if (this.numTypes >= size) {
            this.pointTypes = Path2D.expandPointTypes(this.pointTypes, 1);
        }
        size = this.floatCoords.length;
        if (this.numCoords > this.floatCoords.length - newCoords) {
            this.floatCoords = Path2D.expandCoords(this.floatCoords, newCoords);
        }
    }

    static byte[] expandPointTypes(byte[] oldPointTypes, int needed) {
        int oldSize = oldPointTypes.length;
        int newSizeMin = oldSize + needed;
        if (newSizeMin < oldSize) {
            throw new ArrayIndexOutOfBoundsException("pointTypes exceeds maximum capacity !");
        }
        int grow = oldSize;
        if (grow > 500) {
            grow = Math.max(500, oldSize >> 3);
        } else if (grow < 20) {
            grow = 20;
        }
        assert (grow > 0);
        int newSize = oldSize + grow;
        if (newSize < newSizeMin) {
            newSize = Integer.MAX_VALUE;
        }
        while (true) {
            try {
                return Arrays.copyOf(oldPointTypes, newSize);
            }
            catch (OutOfMemoryError oome) {
                if (newSize == newSizeMin) {
                    throw oome;
                }
                newSize = newSizeMin + (newSize - newSizeMin) / 2;
                continue;
            }
            break;
        }
    }

    static float[] expandCoords(float[] oldCoords, int needed) {
        int oldSize = oldCoords.length;
        int newSizeMin = oldSize + needed;
        if (newSizeMin < oldSize) {
            throw new ArrayIndexOutOfBoundsException("coords exceeds maximum capacity !");
        }
        int grow = oldSize;
        if (grow > 1000) {
            grow = Math.max(1000, oldSize >> 3);
        } else if (grow < 20) {
            grow = 20;
        }
        assert (grow > needed);
        int newSize = oldSize + grow;
        if (newSize < newSizeMin) {
            newSize = Integer.MAX_VALUE;
        }
        while (true) {
            try {
                return Arrays.copyOf(oldCoords, newSize);
            }
            catch (OutOfMemoryError oome) {
                if (newSize == newSizeMin) {
                    throw oome;
                }
                newSize = newSizeMin + (newSize - newSizeMin) / 2;
                continue;
            }
            break;
        }
    }

    @Override
    public final void moveTo(float x, float y) {
        if (this.numTypes > 0 && this.pointTypes[this.numTypes - 1] == 0) {
            this.prevX = this.currX = x;
            this.moveX = this.currX;
            this.floatCoords[this.numCoords - 2] = this.currX;
            this.prevY = this.currY = y;
            this.moveY = this.currY;
            this.floatCoords[this.numCoords - 1] = this.currY;
        } else {
            this.needRoom(false, 2);
            this.pointTypes[this.numTypes++] = 0;
            this.prevX = this.currX = x;
            this.moveX = this.currX;
            this.floatCoords[this.numCoords++] = this.currX;
            this.prevY = this.currY = y;
            this.moveY = this.currY;
            this.floatCoords[this.numCoords++] = this.currY;
        }
    }

    public final void moveToRel(float relx, float rely) {
        if (this.numTypes > 0 && this.pointTypes[this.numTypes - 1] == 0) {
            this.prevX = this.currX += relx;
            this.moveX = this.currX;
            this.floatCoords[this.numCoords - 2] = this.currX;
            this.prevY = this.currY += rely;
            this.moveY = this.currY;
            this.floatCoords[this.numCoords - 1] = this.currY;
        } else {
            this.needRoom(true, 2);
            this.pointTypes[this.numTypes++] = 0;
            this.prevX = this.currX += relx;
            this.moveX = this.currX;
            this.floatCoords[this.numCoords++] = this.currX;
            this.prevY = this.currY += rely;
            this.moveY = this.currY;
            this.floatCoords[this.numCoords++] = this.currY;
        }
    }

    @Override
    public final void lineTo(float x, float y) {
        this.needRoom(true, 2);
        this.pointTypes[this.numTypes++] = 1;
        this.prevX = this.currX = x;
        this.floatCoords[this.numCoords++] = this.currX;
        this.prevY = this.currY = y;
        this.floatCoords[this.numCoords++] = this.currY;
    }

    public final void lineToRel(float relx, float rely) {
        this.needRoom(true, 2);
        this.pointTypes[this.numTypes++] = 1;
        this.prevX = this.currX += relx;
        this.floatCoords[this.numCoords++] = this.currX;
        this.prevY = this.currY += rely;
        this.floatCoords[this.numCoords++] = this.currY;
    }

    @Override
    public final void quadTo(float x1, float y1, float x2, float y2) {
        this.needRoom(true, 4);
        this.pointTypes[this.numTypes++] = 2;
        this.floatCoords[this.numCoords++] = this.prevX = x1;
        this.floatCoords[this.numCoords++] = this.prevY = y1;
        this.floatCoords[this.numCoords++] = this.currX = x2;
        this.floatCoords[this.numCoords++] = this.currY = y2;
    }

    public final void quadToRel(float relx1, float rely1, float relx2, float rely2) {
        this.needRoom(true, 4);
        this.pointTypes[this.numTypes++] = 2;
        this.floatCoords[this.numCoords++] = this.prevX = this.currX + relx1;
        this.floatCoords[this.numCoords++] = this.prevY = this.currY + rely1;
        this.floatCoords[this.numCoords++] = this.currX += relx2;
        this.floatCoords[this.numCoords++] = this.currY += rely2;
    }

    public final void quadToSmooth(float x2, float y2) {
        this.needRoom(true, 4);
        this.pointTypes[this.numTypes++] = 2;
        this.floatCoords[this.numCoords++] = this.prevX = this.currX * 2.0f - this.prevX;
        this.floatCoords[this.numCoords++] = this.prevY = this.currY * 2.0f - this.prevY;
        this.floatCoords[this.numCoords++] = this.currX = x2;
        this.floatCoords[this.numCoords++] = this.currY = y2;
    }

    public final void quadToSmoothRel(float relx2, float rely2) {
        this.needRoom(true, 4);
        this.pointTypes[this.numTypes++] = 2;
        this.floatCoords[this.numCoords++] = this.prevX = this.currX * 2.0f - this.prevX;
        this.floatCoords[this.numCoords++] = this.prevY = this.currY * 2.0f - this.prevY;
        this.floatCoords[this.numCoords++] = this.currX += relx2;
        this.floatCoords[this.numCoords++] = this.currY += rely2;
    }

    @Override
    public final void curveTo(float x1, float y1, float x2, float y2, float x3, float y3) {
        this.needRoom(true, 6);
        this.pointTypes[this.numTypes++] = 3;
        this.floatCoords[this.numCoords++] = x1;
        this.floatCoords[this.numCoords++] = y1;
        this.floatCoords[this.numCoords++] = this.prevX = x2;
        this.floatCoords[this.numCoords++] = this.prevY = y2;
        this.floatCoords[this.numCoords++] = this.currX = x3;
        this.floatCoords[this.numCoords++] = this.currY = y3;
    }

    public final void curveToRel(float relx1, float rely1, float relx2, float rely2, float relx3, float rely3) {
        this.needRoom(true, 6);
        this.pointTypes[this.numTypes++] = 3;
        this.floatCoords[this.numCoords++] = this.currX + relx1;
        this.floatCoords[this.numCoords++] = this.currY + rely1;
        this.floatCoords[this.numCoords++] = this.prevX = this.currX + relx2;
        this.floatCoords[this.numCoords++] = this.prevY = this.currY + rely2;
        this.floatCoords[this.numCoords++] = this.currX += relx3;
        this.floatCoords[this.numCoords++] = this.currY += rely3;
    }

    public final void curveToSmooth(float x2, float y2, float x3, float y3) {
        this.needRoom(true, 6);
        this.pointTypes[this.numTypes++] = 3;
        this.floatCoords[this.numCoords++] = this.currX * 2.0f - this.prevX;
        this.floatCoords[this.numCoords++] = this.currY * 2.0f - this.prevY;
        this.floatCoords[this.numCoords++] = this.prevX = x2;
        this.floatCoords[this.numCoords++] = this.prevY = y2;
        this.floatCoords[this.numCoords++] = this.currX = x3;
        this.floatCoords[this.numCoords++] = this.currY = y3;
    }

    public final void curveToSmoothRel(float relx2, float rely2, float relx3, float rely3) {
        this.needRoom(true, 6);
        this.pointTypes[this.numTypes++] = 3;
        this.floatCoords[this.numCoords++] = this.currX * 2.0f - this.prevX;
        this.floatCoords[this.numCoords++] = this.currY * 2.0f - this.prevY;
        this.floatCoords[this.numCoords++] = this.prevX = this.currX + relx2;
        this.floatCoords[this.numCoords++] = this.prevY = this.currY + rely2;
        this.floatCoords[this.numCoords++] = this.currX += relx3;
        this.floatCoords[this.numCoords++] = this.currY += rely3;
    }

    public final void ovalQuadrantTo(float cx, float cy, float ex, float ey, float tfrom, float tto) {
        if (this.numTypes < 1) {
            throw new IllegalPathStateException("missing initial moveto in path definition");
        }
        this.appendOvalQuadrant(this.currX, this.currY, cx, cy, ex, ey, tfrom, tto, CornerPrefix.CORNER_ONLY);
    }

    public final void appendOvalQuadrant(float sx, float sy, float cx, float cy, float ex, float ey, float tfrom, float tto, CornerPrefix prefix) {
        if (!(tfrom >= 0.0f && tfrom <= tto && tto <= 1.0f)) {
            throw new IllegalArgumentException("0 <= tfrom <= tto <= 1 required");
        }
        float cx0 = (float)((double)sx + (double)(cx - sx) * 0.5522847498307933);
        float cy0 = (float)((double)sy + (double)(cy - sy) * 0.5522847498307933);
        float cx1 = (float)((double)ex + (double)(cx - ex) * 0.5522847498307933);
        float cy1 = (float)((double)ey + (double)(cy - ey) * 0.5522847498307933);
        if (tto < 1.0f) {
            float t = 1.0f - tto;
            ex += (cx1 - ex) * t;
            ey += (cy1 - ey) * t;
            cx1 += (cx0 - cx1) * t;
            cy1 += (cy0 - cy1) * t;
            cx0 += (sx - cx0) * t;
            cy0 += (sy - cy0) * t;
            ex += (cx1 - ex) * t;
            ey += (cy1 - ey) * t;
            cx1 += (cx0 - cx1) * t;
            cy1 += (cy0 - cy1) * t;
            ex += (cx1 - ex) * t;
            ey += (cy1 - ey) * t;
        }
        if (tfrom > 0.0f) {
            if (tto < 1.0f) {
                tfrom /= tto;
            }
            sx += (cx0 - sx) * tfrom;
            sy += (cy0 - sy) * tfrom;
            cx0 += (cx1 - cx0) * tfrom;
            cy0 += (cy1 - cy0) * tfrom;
            cx1 += (ex - cx1) * tfrom;
            cy1 += (ey - cy1) * tfrom;
            sx += (cx0 - sx) * tfrom;
            sy += (cy0 - sy) * tfrom;
            cx0 += (cx1 - cx0) * tfrom;
            cy0 += (cy1 - cy0) * tfrom;
            sx += (cx0 - sx) * tfrom;
            sy += (cy0 - sy) * tfrom;
        }
        if (prefix == CornerPrefix.MOVE_THEN_CORNER) {
            this.moveTo(sx, sy);
        } else if (prefix == CornerPrefix.LINE_THEN_CORNER && (this.numTypes == 1 || sx != this.currX || sy != this.currY)) {
            this.lineTo(sx, sy);
        }
        if (tfrom == tto || sx == cx0 && cx0 == cx1 && cx1 == ex && sy == cy0 && cy0 == cy1 && cy1 == ey) {
            if (prefix != CornerPrefix.LINE_THEN_CORNER) {
                this.lineTo(ex, ey);
            }
        } else {
            this.curveTo(cx0, cy0, cx1, cy1, ex, ey);
        }
    }

    public void arcTo(float radiusx, float radiusy, float xAxisRotation, boolean largeArcFlag, boolean sweepFlag, float x, float y) {
        double sinphi;
        double cosphi;
        if (this.numTypes < 1) {
            throw new IllegalPathStateException("missing initial moveto in path definition");
        }
        double rx = Math.abs(radiusx);
        double ry = Math.abs(radiusy);
        if (rx == 0.0 || ry == 0.0) {
            this.lineTo(x, y);
            return;
        }
        double x1 = this.currX;
        double y1 = this.currY;
        double x2 = x;
        double y2 = y;
        if (x1 == x2 && y1 == y2) {
            return;
        }
        if ((double)xAxisRotation == 0.0) {
            cosphi = 1.0;
            sinphi = 0.0;
        } else {
            cosphi = Math.cos(xAxisRotation);
            sinphi = Math.sin(xAxisRotation);
        }
        double mx = (x1 + x2) / 2.0;
        double my = (y1 + y2) / 2.0;
        double relx1 = x1 - mx;
        double rely1 = y1 - my;
        double x1p = (cosphi * relx1 + sinphi * rely1) / rx;
        double y1p = (cosphi * rely1 - sinphi * relx1) / ry;
        double lenpsq = x1p * x1p + y1p * y1p;
        if (lenpsq >= 1.0) {
            double xqpr = y1p * rx;
            double yqpr = x1p * ry;
            if (sweepFlag) {
                xqpr = -xqpr;
            } else {
                yqpr = -yqpr;
            }
            double relxq = cosphi * xqpr - sinphi * yqpr;
            double relyq = cosphi * yqpr + sinphi * xqpr;
            double xq = mx + relxq;
            double yq = my + relyq;
            double xc = x1 + relxq;
            double yc = y1 + relyq;
            this.appendOvalQuadrant((float)x1, (float)y1, (float)xc, (float)yc, (float)xq, (float)yq, 0.0f, 1.0f, CornerPrefix.CORNER_ONLY);
            xc = x2 + relxq;
            yc = y2 + relyq;
            this.appendOvalQuadrant((float)xq, (float)yq, (float)xc, (float)yc, (float)x2, (float)y2, 0.0f, 1.0f, CornerPrefix.CORNER_ONLY);
            return;
        }
        double scalef = Math.sqrt((1.0 - lenpsq) / lenpsq);
        double cxp = scalef * y1p;
        double cyp = scalef * x1p;
        if (largeArcFlag == sweepFlag) {
            cxp = -cxp;
        } else {
            cyp = -cyp;
        }
        mx += cosphi * cxp * rx - sinphi * cyp * ry;
        my += cosphi * cyp * ry + sinphi * cxp * rx;
        double ux = x1p - cxp;
        double uy = y1p - cyp;
        double vx = -(x1p + cxp);
        double vy = -(y1p + cyp);
        boolean done = false;
        float quadlen = 1.0f;
        boolean wasclose = false;
        do {
            double xqp = uy;
            double yqp = ux;
            if (sweepFlag) {
                xqp = -xqp;
            } else {
                yqp = -yqp;
            }
            if (xqp * vx + yqp * vy > 0.0) {
                double dot = ux * vx + uy * vy;
                if (dot >= 0.0) {
                    quadlen = (float)(Math.acos(dot) / 1.5707963267948966);
                    done = true;
                }
                wasclose = true;
            } else if (wasclose) break;
            double relxq = cosphi * xqp * rx - sinphi * yqp * ry;
            double relyq = cosphi * yqp * ry + sinphi * xqp * rx;
            double xq = mx + relxq;
            double yq = my + relyq;
            double xc = x1 + relxq;
            double yc = y1 + relyq;
            this.appendOvalQuadrant((float)x1, (float)y1, (float)xc, (float)yc, (float)xq, (float)yq, 0.0f, quadlen, CornerPrefix.CORNER_ONLY);
            x1 = xq;
            y1 = yq;
            ux = xqp;
            uy = yqp;
        } while (!done);
    }

    public void arcToRel(float radiusx, float radiusy, float xAxisRotation, boolean largeArcFlag, boolean sweepFlag, float relx, float rely) {
        this.arcTo(radiusx, radiusy, xAxisRotation, largeArcFlag, sweepFlag, this.currX + relx, this.currY + rely);
    }

    int pointCrossings(float px, float py) {
        float movy;
        float movx;
        float[] coords = this.floatCoords;
        float curx = movx = coords[0];
        float cury = movy = coords[1];
        int crossings = 0;
        int ci = 2;
        block7: for (int i = 1; i < this.numTypes; ++i) {
            switch (this.pointTypes[i]) {
                case 0: {
                    if (cury != movy) {
                        crossings += Shape.pointCrossingsForLine(px, py, curx, cury, movx, movy);
                    }
                    movx = curx = coords[ci++];
                    movy = cury = coords[ci++];
                    continue block7;
                }
                case 1: {
                    float endx = coords[ci++];
                    float endy = coords[ci++];
                    crossings += Shape.pointCrossingsForLine(px, py, curx, cury, endx, endy);
                    curx = endx;
                    cury = endy;
                    continue block7;
                }
                case 2: {
                    int n = ci++;
                    int n2 = ci++;
                    float endx = coords[ci++];
                    float endy = coords[ci++];
                    crossings += Shape.pointCrossingsForQuad(px, py, curx, cury, coords[n], coords[n2], endx, endy, 0);
                    curx = endx;
                    cury = endy;
                    continue block7;
                }
                case 3: {
                    int n = ci++;
                    int n3 = ci++;
                    int n4 = ci++;
                    int n5 = ci++;
                    float endx = coords[ci++];
                    float endy = coords[ci++];
                    crossings += Shape.pointCrossingsForCubic(px, py, curx, cury, coords[n], coords[n3], coords[n4], coords[n5], endx, endy, 0);
                    curx = endx;
                    cury = endy;
                    continue block7;
                }
                case 4: {
                    if (cury != movy) {
                        crossings += Shape.pointCrossingsForLine(px, py, curx, cury, movx, movy);
                    }
                    curx = movx;
                    cury = movy;
                }
            }
        }
        if (cury != movy) {
            crossings += Shape.pointCrossingsForLine(px, py, curx, cury, movx, movy);
        }
        return crossings;
    }

    int rectCrossings(float rxmin, float rymin, float rxmax, float rymax) {
        float movy;
        float movx;
        float[] coords = this.floatCoords;
        float curx = movx = coords[0];
        float cury = movy = coords[1];
        int crossings = 0;
        int ci = 2;
        block7: for (int i = 1; crossings != Integer.MIN_VALUE && i < this.numTypes; ++i) {
            switch (this.pointTypes[i]) {
                case 0: {
                    if (curx != movx || cury != movy) {
                        crossings = Shape.rectCrossingsForLine(crossings, rxmin, rymin, rxmax, rymax, curx, cury, movx, movy);
                    }
                    movx = curx = coords[ci++];
                    movy = cury = coords[ci++];
                    continue block7;
                }
                case 1: {
                    float endx = coords[ci++];
                    float endy = coords[ci++];
                    crossings = Shape.rectCrossingsForLine(crossings, rxmin, rymin, rxmax, rymax, curx, cury, endx, endy);
                    curx = endx;
                    cury = endy;
                    continue block7;
                }
                case 2: {
                    int n = ci++;
                    int n2 = ci++;
                    float endx = coords[ci++];
                    float endy = coords[ci++];
                    crossings = Shape.rectCrossingsForQuad(crossings, rxmin, rymin, rxmax, rymax, curx, cury, coords[n], coords[n2], endx, endy, 0);
                    curx = endx;
                    cury = endy;
                    continue block7;
                }
                case 3: {
                    int n = ci++;
                    int n3 = ci++;
                    int n4 = ci++;
                    int n5 = ci++;
                    float endx = coords[ci++];
                    float endy = coords[ci++];
                    crossings = Shape.rectCrossingsForCubic(crossings, rxmin, rymin, rxmax, rymax, curx, cury, coords[n], coords[n3], coords[n4], coords[n5], endx, endy, 0);
                    curx = endx;
                    cury = endy;
                    continue block7;
                }
                case 4: {
                    if (curx != movx || cury != movy) {
                        crossings = Shape.rectCrossingsForLine(crossings, rxmin, rymin, rxmax, rymax, curx, cury, movx, movy);
                    }
                    curx = movx;
                    cury = movy;
                }
            }
        }
        if (crossings != Integer.MIN_VALUE && (curx != movx || cury != movy)) {
            crossings = Shape.rectCrossingsForLine(crossings, rxmin, rymin, rxmax, rymax, curx, cury, movx, movy);
        }
        return crossings;
    }

    public final void append(PathIterator pi, boolean connect) {
        float[] coords = new float[6];
        while (!pi.isDone()) {
            switch (pi.currentSegment(coords)) {
                case 0: {
                    if (!connect || this.numTypes < 1 || this.numCoords < 1) {
                        this.moveTo(coords[0], coords[1]);
                        break;
                    }
                    if (this.pointTypes[this.numTypes - 1] != 4 && this.floatCoords[this.numCoords - 2] == coords[0] && this.floatCoords[this.numCoords - 1] == coords[1]) break;
                }
                case 1: {
                    this.lineTo(coords[0], coords[1]);
                    break;
                }
                case 2: {
                    this.quadTo(coords[0], coords[1], coords[2], coords[3]);
                    break;
                }
                case 3: {
                    this.curveTo(coords[0], coords[1], coords[2], coords[3], coords[4], coords[5]);
                    break;
                }
                case 4: {
                    this.closePath();
                }
            }
            pi.next();
            connect = false;
        }
    }

    public final void transform(BaseTransform tx) {
        if (this.numCoords == 0) {
            return;
        }
        this.needRoom(false, 6);
        this.floatCoords[this.numCoords + 0] = this.moveX;
        this.floatCoords[this.numCoords + 1] = this.moveY;
        this.floatCoords[this.numCoords + 2] = this.prevX;
        this.floatCoords[this.numCoords + 3] = this.prevY;
        this.floatCoords[this.numCoords + 4] = this.currX;
        this.floatCoords[this.numCoords + 5] = this.currY;
        tx.transform(this.floatCoords, 0, this.floatCoords, 0, this.numCoords / 2 + 3);
        this.moveX = this.floatCoords[this.numCoords + 0];
        this.moveY = this.floatCoords[this.numCoords + 1];
        this.prevX = this.floatCoords[this.numCoords + 2];
        this.prevY = this.floatCoords[this.numCoords + 3];
        this.currX = this.floatCoords[this.numCoords + 4];
        this.currY = this.floatCoords[this.numCoords + 5];
    }

    @Override
    public final RectBounds getBounds() {
        float x1;
        float x2;
        float y1;
        float y2;
        int i = this.numCoords;
        if (i > 0) {
            y1 = y2 = this.floatCoords[--i];
            x1 = x2 = this.floatCoords[--i];
            while (i > 0) {
                float x;
                float y = this.floatCoords[--i];
                if ((x = this.floatCoords[--i]) < x1) {
                    x1 = x;
                }
                if (y < y1) {
                    y1 = y;
                }
                if (x > x2) {
                    x2 = x;
                }
                if (!(y > y2)) continue;
                y2 = y;
            }
        } else {
            y2 = 0.0f;
            x2 = 0.0f;
            y1 = 0.0f;
            x1 = 0.0f;
        }
        return new RectBounds(x1, y1, x2, y2);
    }

    public final int getNumCommands() {
        return this.numTypes;
    }

    public final byte[] getCommandsNoClone() {
        return this.pointTypes;
    }

    public final float[] getFloatCoordsNoClone() {
        return this.floatCoords;
    }

    @Override
    public PathIterator getPathIterator(BaseTransform tx) {
        if (tx == null) {
            return new CopyIterator(this);
        }
        return new TxIterator(this, tx);
    }

    @Override
    public final void closePath() {
        if (this.numTypes == 0 || this.pointTypes[this.numTypes - 1] != 4) {
            this.needRoom(true, 0);
            this.pointTypes[this.numTypes++] = 4;
            this.prevX = this.currX = this.moveX;
            this.prevY = this.currY = this.moveY;
        }
    }

    @Override
    public void pathDone() {
    }

    public final void append(Shape s, boolean connect) {
        this.append(s.getPathIterator(null), connect);
    }

    public final void appendSVGPath(String svgpath) {
        SVGParser p = new SVGParser(svgpath);
        p.allowcomma = false;
        while (!p.isDone()) {
            p.allowcomma = false;
            char cmd = p.getChar();
            switch (cmd) {
                case 'M': {
                    this.moveTo(p.f(), p.f());
                    while (p.nextIsNumber()) {
                        this.lineTo(p.f(), p.f());
                    }
                    break;
                }
                case 'm': {
                    if (this.numTypes > 0) {
                        this.moveToRel(p.f(), p.f());
                    } else {
                        this.moveTo(p.f(), p.f());
                    }
                    while (p.nextIsNumber()) {
                        this.lineToRel(p.f(), p.f());
                    }
                    break;
                }
                case 'L': {
                    do {
                        this.lineTo(p.f(), p.f());
                    } while (p.nextIsNumber());
                    break;
                }
                case 'l': {
                    do {
                        this.lineToRel(p.f(), p.f());
                    } while (p.nextIsNumber());
                    break;
                }
                case 'H': {
                    do {
                        this.lineTo(p.f(), this.currY);
                    } while (p.nextIsNumber());
                    break;
                }
                case 'h': {
                    do {
                        this.lineToRel(p.f(), 0.0f);
                    } while (p.nextIsNumber());
                    break;
                }
                case 'V': {
                    do {
                        this.lineTo(this.currX, p.f());
                    } while (p.nextIsNumber());
                    break;
                }
                case 'v': {
                    do {
                        this.lineToRel(0.0f, p.f());
                    } while (p.nextIsNumber());
                    break;
                }
                case 'Q': {
                    do {
                        this.quadTo(p.f(), p.f(), p.f(), p.f());
                    } while (p.nextIsNumber());
                    break;
                }
                case 'q': {
                    do {
                        this.quadToRel(p.f(), p.f(), p.f(), p.f());
                    } while (p.nextIsNumber());
                    break;
                }
                case 'T': {
                    do {
                        this.quadToSmooth(p.f(), p.f());
                    } while (p.nextIsNumber());
                    break;
                }
                case 't': {
                    do {
                        this.quadToSmoothRel(p.f(), p.f());
                    } while (p.nextIsNumber());
                    break;
                }
                case 'C': {
                    do {
                        this.curveTo(p.f(), p.f(), p.f(), p.f(), p.f(), p.f());
                    } while (p.nextIsNumber());
                    break;
                }
                case 'c': {
                    do {
                        this.curveToRel(p.f(), p.f(), p.f(), p.f(), p.f(), p.f());
                    } while (p.nextIsNumber());
                    break;
                }
                case 'S': {
                    do {
                        this.curveToSmooth(p.f(), p.f(), p.f(), p.f());
                    } while (p.nextIsNumber());
                    break;
                }
                case 's': {
                    do {
                        this.curveToSmoothRel(p.f(), p.f(), p.f(), p.f());
                    } while (p.nextIsNumber());
                    break;
                }
                case 'A': {
                    do {
                        this.arcTo(p.f(), p.f(), p.a(), p.b(), p.b(), p.f(), p.f());
                    } while (p.nextIsNumber());
                    break;
                }
                case 'a': {
                    do {
                        this.arcToRel(p.f(), p.f(), p.a(), p.b(), p.b(), p.f(), p.f());
                    } while (p.nextIsNumber());
                    break;
                }
                case 'Z': 
                case 'z': {
                    this.closePath();
                    break;
                }
                default: {
                    throw new IllegalArgumentException("invalid command (" + cmd + ") in SVG path at pos=" + p.pos);
                }
            }
            p.allowcomma = false;
        }
    }

    public final int getWindingRule() {
        return this.windingRule;
    }

    public final void setWindingRule(int rule) {
        if (rule != 0 && rule != 1) {
            throw new IllegalArgumentException("winding rule must be WIND_EVEN_ODD or WIND_NON_ZERO");
        }
        this.windingRule = rule;
    }

    public final Point2D getCurrentPoint() {
        if (this.numTypes < 1) {
            return null;
        }
        return new Point2D(this.currX, this.currY);
    }

    public final float getCurrentX() {
        if (this.numTypes < 1) {
            throw new IllegalPathStateException("no current point in empty path");
        }
        return this.currX;
    }

    public final float getCurrentY() {
        if (this.numTypes < 1) {
            throw new IllegalPathStateException("no current point in empty path");
        }
        return this.currY;
    }

    public final void reset() {
        this.numCoords = 0;
        this.numTypes = 0;
        this.currY = 0.0f;
        this.currX = 0.0f;
        this.prevY = 0.0f;
        this.prevX = 0.0f;
        this.moveY = 0.0f;
        this.moveX = 0.0f;
    }

    public final Shape createTransformedShape(BaseTransform tx) {
        return new Path2D(this, tx);
    }

    @Override
    public Path2D copy() {
        return new Path2D(this);
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj instanceof Path2D) {
            Path2D p = (Path2D)obj;
            if (p.numTypes == this.numTypes && p.numCoords == this.numCoords && p.windingRule == this.windingRule) {
                int i;
                for (i = 0; i < this.numTypes; ++i) {
                    if (p.pointTypes[i] == this.pointTypes[i]) continue;
                    return false;
                }
                for (i = 0; i < this.numCoords; ++i) {
                    if (p.floatCoords[i] == this.floatCoords[i]) continue;
                    return false;
                }
                return true;
            }
        }
        return false;
    }

    public int hashCode() {
        int i;
        int hash = 7;
        hash = 11 * hash + this.numTypes;
        hash = 11 * hash + this.numCoords;
        hash = 11 * hash + this.windingRule;
        for (i = 0; i < this.numTypes; ++i) {
            hash = 11 * hash + this.pointTypes[i];
        }
        for (i = 0; i < this.numCoords; ++i) {
            hash = 11 * hash + Float.floatToIntBits(this.floatCoords[i]);
        }
        return hash;
    }

    public static boolean contains(PathIterator pi, float x, float y) {
        if (x * 0.0f + y * 0.0f == 0.0f) {
            int mask = pi.getWindingRule() == 1 ? -1 : 1;
            int cross = Shape.pointCrossingsForPath(pi, x, y);
            return (cross & mask) != 0;
        }
        return false;
    }

    public static boolean contains(PathIterator pi, Point2D p) {
        return Path2D.contains(pi, p.x, p.y);
    }

    @Override
    public final boolean contains(float x, float y) {
        if (x * 0.0f + y * 0.0f == 0.0f) {
            if (this.numTypes < 2) {
                return false;
            }
            int mask = this.windingRule == 1 ? -1 : 1;
            return (this.pointCrossings(x, y) & mask) != 0;
        }
        return false;
    }

    @Override
    public final boolean contains(Point2D p) {
        return this.contains(p.x, p.y);
    }

    public static boolean contains(PathIterator pi, float x, float y, float w, float h) {
        if (Float.isNaN(x + w) || Float.isNaN(y + h)) {
            return false;
        }
        if (w <= 0.0f || h <= 0.0f) {
            return false;
        }
        int mask = pi.getWindingRule() == 1 ? -1 : 2;
        int crossings = Shape.rectCrossingsForPath(pi, x, y, x + w, y + h);
        return crossings != Integer.MIN_VALUE && (crossings & mask) != 0;
    }

    @Override
    public final boolean contains(float x, float y, float w, float h) {
        if (Float.isNaN(x + w) || Float.isNaN(y + h)) {
            return false;
        }
        if (w <= 0.0f || h <= 0.0f) {
            return false;
        }
        int mask = this.windingRule == 1 ? -1 : 2;
        int crossings = this.rectCrossings(x, y, x + w, y + h);
        return crossings != Integer.MIN_VALUE && (crossings & mask) != 0;
    }

    public static boolean intersects(PathIterator pi, float x, float y, float w, float h) {
        if (Float.isNaN(x + w) || Float.isNaN(y + h)) {
            return false;
        }
        if (w <= 0.0f || h <= 0.0f) {
            return false;
        }
        int mask = pi.getWindingRule() == 1 ? -1 : 2;
        int crossings = Shape.rectCrossingsForPath(pi, x, y, x + w, y + h);
        return crossings == Integer.MIN_VALUE || (crossings & mask) != 0;
    }

    @Override
    public final boolean intersects(float x, float y, float w, float h) {
        if (Float.isNaN(x + w) || Float.isNaN(y + h)) {
            return false;
        }
        if (w <= 0.0f || h <= 0.0f) {
            return false;
        }
        int mask = this.windingRule == 1 ? -1 : 2;
        int crossings = this.rectCrossings(x, y, x + w, y + h);
        return crossings == Integer.MIN_VALUE || (crossings & mask) != 0;
    }

    @Override
    public PathIterator getPathIterator(BaseTransform tx, float flatness) {
        return new FlatteningPathIterator(this.getPathIterator(tx), flatness);
    }

    public void setTo(Path2D otherPath) {
        this.numTypes = otherPath.numTypes;
        this.numCoords = otherPath.numCoords;
        if (this.numTypes > this.pointTypes.length) {
            this.pointTypes = new byte[this.numTypes];
        }
        System.arraycopy(otherPath.pointTypes, 0, this.pointTypes, 0, this.numTypes);
        if (this.numCoords > this.floatCoords.length) {
            this.floatCoords = new float[this.numCoords];
        }
        System.arraycopy(otherPath.floatCoords, 0, this.floatCoords, 0, this.numCoords);
        this.windingRule = otherPath.windingRule;
        this.moveX = otherPath.moveX;
        this.moveY = otherPath.moveY;
        this.prevX = otherPath.prevX;
        this.prevY = otherPath.prevY;
        this.currX = otherPath.currX;
        this.currY = otherPath.currY;
    }

    static abstract class Iterator
    implements PathIterator {
        int typeIdx;
        int pointIdx;
        Path2D path;

        Iterator(Path2D path) {
            this.path = path;
        }

        @Override
        public int getWindingRule() {
            return this.path.getWindingRule();
        }

        @Override
        public boolean isDone() {
            return this.typeIdx >= this.path.numTypes;
        }

        @Override
        public void next() {
            byte type = this.path.pointTypes[this.typeIdx++];
            this.pointIdx += curvecoords[type];
        }
    }

    static class SVGParser {
        final String svgpath;
        final int len;
        int pos;
        boolean allowcomma;

        public SVGParser(String svgpath) {
            this.svgpath = svgpath;
            this.len = svgpath.length();
        }

        public boolean isDone() {
            return this.toNextNonWsp() >= this.len;
        }

        public char getChar() {
            return this.svgpath.charAt(this.pos++);
        }

        public boolean nextIsNumber() {
            if (this.toNextNonWsp() < this.len) {
                switch (this.svgpath.charAt(this.pos)) {
                    case '+': 
                    case '-': 
                    case '.': 
                    case '0': 
                    case '1': 
                    case '2': 
                    case '3': 
                    case '4': 
                    case '5': 
                    case '6': 
                    case '7': 
                    case '8': 
                    case '9': {
                        return true;
                    }
                }
            }
            return false;
        }

        public float f() {
            return this.getFloat();
        }

        public float a() {
            return (float)Math.toRadians(this.getFloat());
        }

        public float getFloat() {
            int start = this.toNextNonWsp();
            this.allowcomma = true;
            int end = this.toNumberEnd();
            if (start < end) {
                String flstr = this.svgpath.substring(start, end);
                try {
                    return Float.parseFloat(flstr);
                }
                catch (NumberFormatException numberFormatException) {
                    throw new IllegalArgumentException("invalid float (" + flstr + ") in path at pos=" + start);
                }
            }
            throw new IllegalArgumentException("end of path looking for float");
        }

        public boolean b() {
            this.toNextNonWsp();
            this.allowcomma = true;
            if (this.pos < this.len) {
                char flag = this.svgpath.charAt(this.pos);
                switch (flag) {
                    case '0': {
                        ++this.pos;
                        return false;
                    }
                    case '1': {
                        ++this.pos;
                        return true;
                    }
                }
                throw new IllegalArgumentException("invalid boolean flag (" + flag + ") in path at pos=" + this.pos);
            }
            throw new IllegalArgumentException("end of path looking for boolean");
        }

        private int toNextNonWsp() {
            boolean canbecomma = this.allowcomma;
            while (this.pos < this.len) {
                switch (this.svgpath.charAt(this.pos)) {
                    case ',': {
                        if (!canbecomma) {
                            return this.pos;
                        }
                        canbecomma = false;
                        break;
                    }
                    case '\t': 
                    case '\n': 
                    case '\r': 
                    case ' ': {
                        break;
                    }
                    default: {
                        return this.pos;
                    }
                }
                ++this.pos;
            }
            return this.pos;
        }

        private int toNumberEnd() {
            boolean allowsign = true;
            boolean hasexp = false;
            boolean hasdecimal = false;
            while (this.pos < this.len) {
                switch (this.svgpath.charAt(this.pos)) {
                    case '+': 
                    case '-': {
                        if (!allowsign) {
                            return this.pos;
                        }
                        allowsign = false;
                        break;
                    }
                    case '0': 
                    case '1': 
                    case '2': 
                    case '3': 
                    case '4': 
                    case '5': 
                    case '6': 
                    case '7': 
                    case '8': 
                    case '9': {
                        allowsign = false;
                        break;
                    }
                    case 'E': 
                    case 'e': {
                        if (hasexp) {
                            return this.pos;
                        }
                        allowsign = true;
                        hasexp = true;
                        break;
                    }
                    case '.': {
                        if (hasexp || hasdecimal) {
                            return this.pos;
                        }
                        hasdecimal = true;
                        allowsign = false;
                        break;
                    }
                    default: {
                        return this.pos;
                    }
                }
                ++this.pos;
            }
            return this.pos;
        }
    }

    static class TxIterator
    extends Iterator {
        float[] floatCoords;
        BaseTransform transform;

        TxIterator(Path2D p2df, BaseTransform tx) {
            super(p2df);
            this.floatCoords = p2df.floatCoords;
            this.transform = tx;
        }

        @Override
        public int currentSegment(float[] coords) {
            byte type = this.path.pointTypes[this.typeIdx];
            int numCoords = curvecoords[type];
            if (numCoords > 0) {
                this.transform.transform(this.floatCoords, this.pointIdx, coords, 0, numCoords / 2);
            }
            return type;
        }

        public int currentSegment(double[] coords) {
            byte type = this.path.pointTypes[this.typeIdx];
            int numCoords = curvecoords[type];
            if (numCoords > 0) {
                this.transform.transform(this.floatCoords, this.pointIdx, coords, 0, numCoords / 2);
            }
            return type;
        }
    }

    static class CopyIterator
    extends Iterator {
        float[] floatCoords;

        CopyIterator(Path2D p2df) {
            super(p2df);
            this.floatCoords = p2df.floatCoords;
        }

        @Override
        public int currentSegment(float[] coords) {
            byte type = this.path.pointTypes[this.typeIdx];
            int numCoords = curvecoords[type];
            if (numCoords > 0) {
                System.arraycopy(this.floatCoords, this.pointIdx, coords, 0, numCoords);
            }
            return type;
        }

        public int currentSegment(double[] coords) {
            byte type = this.path.pointTypes[this.typeIdx];
            int numCoords = curvecoords[type];
            if (numCoords > 0) {
                for (int i = 0; i < numCoords; ++i) {
                    coords[i] = this.floatCoords[this.pointIdx + i];
                }
            }
            return type;
        }
    }

    public static enum CornerPrefix {
        CORNER_ONLY,
        MOVE_THEN_CORNER,
        LINE_THEN_CORNER;

    }
}

