/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javafx.geom;

import com.sun.javafx.geom.LineIterator;
import com.sun.javafx.geom.PathIterator;
import com.sun.javafx.geom.Point2D;
import com.sun.javafx.geom.RectBounds;
import com.sun.javafx.geom.Shape;
import com.sun.javafx.geom.transform.BaseTransform;

public class Line2D
extends Shape {
    public float x1;
    public float y1;
    public float x2;
    public float y2;

    public Line2D() {
    }

    public Line2D(float x1, float y1, float x2, float y2) {
        this.setLine(x1, y1, x2, y2);
    }

    public Line2D(Point2D p1, Point2D p2) {
        this.setLine(p1, p2);
    }

    public void setLine(float x1, float y1, float x2, float y2) {
        this.x1 = x1;
        this.y1 = y1;
        this.x2 = x2;
        this.y2 = y2;
    }

    public void setLine(Point2D p1, Point2D p2) {
        this.setLine(p1.x, p1.y, p2.x, p2.y);
    }

    public void setLine(Line2D l) {
        this.setLine(l.x1, l.y1, l.x2, l.y2);
    }

    @Override
    public RectBounds getBounds() {
        RectBounds b = new RectBounds();
        b.setBoundsAndSort(this.x1, this.y1, this.x2, this.y2);
        return b;
    }

    @Override
    public boolean contains(float x, float y) {
        return false;
    }

    @Override
    public boolean contains(float x, float y, float w, float h) {
        return false;
    }

    @Override
    public boolean contains(Point2D p) {
        return false;
    }

    @Override
    public boolean intersects(float x, float y, float w, float h) {
        int out1;
        int out2 = Line2D.outcode(x, y, w, h, this.x2, this.y2);
        if (out2 == 0) {
            return true;
        }
        float px = this.x1;
        float py = this.y1;
        while ((out1 = Line2D.outcode(x, y, w, h, px, py)) != 0) {
            if ((out1 & out2) != 0) {
                return false;
            }
            if ((out1 & 5) != 0) {
                px = x;
                if ((out1 & 4) != 0) {
                    px += w;
                }
                py = this.y1 + (px - this.x1) * (this.y2 - this.y1) / (this.x2 - this.x1);
                continue;
            }
            py = y;
            if ((out1 & 8) != 0) {
                py += h;
            }
            px = this.x1 + (py - this.y1) * (this.x2 - this.x1) / (this.y2 - this.y1);
        }
        return true;
    }

    public static int relativeCCW(float x1, float y1, float x2, float y2, float px, float py) {
        float ccw = (px -= x1) * (y2 -= y1) - (py -= y1) * (x2 -= x1);
        if (ccw == 0.0f && (ccw = px * x2 + py * y2) > 0.0f && (ccw = (px -= x2) * x2 + (py -= y2) * y2) < 0.0f) {
            ccw = 0.0f;
        }
        return ccw < 0.0f ? -1 : (ccw > 0.0f ? 1 : 0);
    }

    public int relativeCCW(float px, float py) {
        return Line2D.relativeCCW(this.x1, this.y1, this.x2, this.y2, px, py);
    }

    public int relativeCCW(Point2D p) {
        return Line2D.relativeCCW(this.x1, this.y1, this.x2, this.y2, p.x, p.y);
    }

    public static boolean linesIntersect(float x1, float y1, float x2, float y2, float x3, float y3, float x4, float y4) {
        return Line2D.relativeCCW(x1, y1, x2, y2, x3, y3) * Line2D.relativeCCW(x1, y1, x2, y2, x4, y4) <= 0 && Line2D.relativeCCW(x3, y3, x4, y4, x1, y1) * Line2D.relativeCCW(x3, y3, x4, y4, x2, y2) <= 0;
    }

    public boolean intersectsLine(float x1, float y1, float x2, float y2) {
        return Line2D.linesIntersect(x1, y1, x2, y2, this.x1, this.y1, this.x2, this.y2);
    }

    public boolean intersectsLine(Line2D l) {
        return Line2D.linesIntersect(l.x1, l.y1, l.x2, l.y2, this.x1, this.y1, this.x2, this.y2);
    }

    public static float ptSegDistSq(float x1, float y1, float x2, float y2, float px, float py) {
        float projlenSq;
        float lenSq;
        float dotprod = (px -= x1) * (x2 -= x1) + (py -= y1) * (y2 -= y1);
        if ((lenSq = px * px + py * py - (projlenSq = dotprod <= 0.0f ? 0.0f : ((dotprod = (px = x2 - px) * x2 + (py = y2 - py) * y2) <= 0.0f ? 0.0f : dotprod * dotprod / (x2 * x2 + y2 * y2)))) < 0.0f) {
            lenSq = 0.0f;
        }
        return lenSq;
    }

    public static float ptSegDist(float x1, float y1, float x2, float y2, float px, float py) {
        return (float)Math.sqrt(Line2D.ptSegDistSq(x1, y1, x2, y2, px, py));
    }

    public float ptSegDistSq(float px, float py) {
        return Line2D.ptSegDistSq(this.x1, this.y1, this.x2, this.y2, px, py);
    }

    public float ptSegDistSq(Point2D pt) {
        return Line2D.ptSegDistSq(this.x1, this.y1, this.x2, this.y2, pt.x, pt.y);
    }

    public double ptSegDist(float px, float py) {
        return Line2D.ptSegDist(this.x1, this.y1, this.x2, this.y2, px, py);
    }

    public float ptSegDist(Point2D pt) {
        return Line2D.ptSegDist(this.x1, this.y1, this.x2, this.y2, pt.x, pt.y);
    }

    public static float ptLineDistSq(float x1, float y1, float x2, float y2, float px, float py) {
        float dotprod;
        float projlenSq;
        float lenSq;
        if ((lenSq = (px -= x1) * px + (py -= y1) * py - (projlenSq = (dotprod = px * (x2 -= x1) + py * (y2 -= y1)) * dotprod / (x2 * x2 + y2 * y2))) < 0.0f) {
            lenSq = 0.0f;
        }
        return lenSq;
    }

    public static float ptLineDist(float x1, float y1, float x2, float y2, float px, float py) {
        return (float)Math.sqrt(Line2D.ptLineDistSq(x1, y1, x2, y2, px, py));
    }

    public float ptLineDistSq(float px, float py) {
        return Line2D.ptLineDistSq(this.x1, this.y1, this.x2, this.y2, px, py);
    }

    public float ptLineDistSq(Point2D pt) {
        return Line2D.ptLineDistSq(this.x1, this.y1, this.x2, this.y2, pt.x, pt.y);
    }

    public float ptLineDist(float px, float py) {
        return Line2D.ptLineDist(this.x1, this.y1, this.x2, this.y2, px, py);
    }

    public float ptLineDist(Point2D pt) {
        return Line2D.ptLineDist(this.x1, this.y1, this.x2, this.y2, pt.x, pt.y);
    }

    @Override
    public PathIterator getPathIterator(BaseTransform tx) {
        return new LineIterator(this, tx);
    }

    @Override
    public PathIterator getPathIterator(BaseTransform tx, float flatness) {
        return new LineIterator(this, tx);
    }

    @Override
    public Line2D copy() {
        return new Line2D(this.x1, this.y1, this.x2, this.y2);
    }

    public int hashCode() {
        int bits = Float.floatToIntBits(this.x1);
        bits += Float.floatToIntBits(this.y1) * 37;
        bits += Float.floatToIntBits(this.x2) * 43;
        return bits += Float.floatToIntBits(this.y2) * 47;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj instanceof Line2D) {
            Line2D line = (Line2D)obj;
            return this.x1 == line.x1 && this.y1 == line.y1 && this.x2 == line.x2 && this.y2 == line.y2;
        }
        return false;
    }
}

