/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javafx.font.coretext;

import com.sun.javafx.font.Glyph;
import com.sun.javafx.font.coretext.CGAffineTransform;
import com.sun.javafx.font.coretext.CGRect;
import com.sun.javafx.font.coretext.CGSize;
import com.sun.javafx.font.coretext.CTFontFile;
import com.sun.javafx.font.coretext.CTFontStrike;
import com.sun.javafx.font.coretext.OS;
import com.sun.javafx.geom.RectBounds;
import com.sun.javafx.geom.Shape;

class CTGlyph
implements Glyph {
    private CTFontStrike strike;
    private int glyphCode;
    private CGRect bounds;
    private double xAdvance;
    private double yAdvance;
    private boolean drawShapes;
    private static boolean LCD_CONTEXT = true;
    private static boolean CACHE_CONTEXT = true;
    private static long cachedContextRef;
    private static final int BITMAP_WIDTH = 256;
    private static final int BITMAP_HEIGHT = 256;
    private static final int MAX_SIZE = 320;
    private static final long GRAY_COLORSPACE;
    private static final long RGB_COLORSPACE;

    CTGlyph(CTFontStrike strike, int glyphCode, boolean drawShapes) {
        this.strike = strike;
        this.glyphCode = glyphCode;
        this.drawShapes = drawShapes;
    }

    @Override
    public int getGlyphCode() {
        return this.glyphCode;
    }

    @Override
    public RectBounds getBBox() {
        CGRect rect = this.strike.getBBox(this.glyphCode);
        if (rect == null) {
            return new RectBounds();
        }
        return new RectBounds((float)rect.origin.x, (float)rect.origin.y, (float)(rect.origin.x + rect.size.width), (float)(rect.origin.y + rect.size.height));
    }

    private void checkBounds() {
        if (this.bounds != null) {
            return;
        }
        this.bounds = new CGRect();
        if (this.strike.getSize() == 0.0f) {
            return;
        }
        long fontRef = this.strike.getFontRef();
        if (fontRef == 0L) {
            return;
        }
        int orientation = 0;
        CGSize size = new CGSize();
        OS.CTFontGetAdvancesForGlyphs(fontRef, orientation, (short)this.glyphCode, size);
        this.xAdvance = size.width;
        this.yAdvance = -size.height;
        if (this.drawShapes) {
            return;
        }
        CTFontFile fr = (CTFontFile)this.strike.getFontResource();
        float[] bb = new float[4];
        fr.getGlyphBoundingBox((short)this.glyphCode, this.strike.getSize(), bb);
        this.bounds.origin.x = bb[0];
        this.bounds.origin.y = bb[1];
        this.bounds.size.width = bb[2] - bb[0];
        this.bounds.size.height = bb[3] - bb[1];
        if (this.strike.matrix != null) {
            OS.CGRectApplyAffineTransform(this.bounds, this.strike.matrix);
        }
        if (this.bounds.size.width < 0.0 || this.bounds.size.height < 0.0 || this.bounds.size.width > 320.0 || this.bounds.size.height > 320.0) {
            this.bounds.size.height = 0.0;
            this.bounds.size.width = 0.0;
            this.bounds.origin.y = 0.0;
            this.bounds.origin.x = 0.0;
        } else {
            this.bounds.origin.x = (int)Math.floor(this.bounds.origin.x) - 1;
            this.bounds.origin.y = (int)Math.floor(this.bounds.origin.y) - 1;
            this.bounds.size.width = (int)Math.ceil(this.bounds.size.width) + 1 + 1 + 1;
            this.bounds.size.height = (int)Math.ceil(this.bounds.size.height) + 1 + 1 + 1;
        }
    }

    @Override
    public Shape getShape() {
        return this.strike.createGlyphOutline(this.glyphCode);
    }

    private long createContext(boolean lcd, int width, int height) {
        int flags;
        int bpr;
        long space;
        int bpc = 8;
        if (lcd) {
            space = RGB_COLORSPACE;
            bpr = width * 4;
            flags = OS.kCGBitmapByteOrder32Host | 2;
        } else {
            space = GRAY_COLORSPACE;
            bpr = width;
            flags = 0;
        }
        long context = OS.CGBitmapContextCreate(0L, width, height, bpc, bpr, space, flags);
        boolean subPixel = this.strike.isSubPixelGlyph();
        OS.CGContextSetAllowsFontSmoothing(context, lcd);
        OS.CGContextSetAllowsAntialiasing(context, true);
        OS.CGContextSetAllowsFontSubpixelPositioning(context, subPixel);
        OS.CGContextSetAllowsFontSubpixelQuantization(context, subPixel);
        return context;
    }

    private long getCachedContext(boolean lcd) {
        if (cachedContextRef == 0L) {
            cachedContextRef = this.createContext(lcd, 256, 256);
        }
        return cachedContextRef;
    }

    private synchronized byte[] getImage(double x, double y, int w, int h, int subPixel) {
        byte[] imageData;
        long context;
        if (w == 0 || h == 0) {
            return new byte[0];
        }
        long fontRef = this.strike.getFontRef();
        boolean lcd = this.isLCDGlyph();
        boolean lcdContext = LCD_CONTEXT || lcd;
        CGAffineTransform matrix = this.strike.matrix;
        boolean cache = CACHE_CONTEXT & 256 >= w & 256 >= h;
        long l = context = cache ? this.getCachedContext(lcdContext) : this.createContext(lcdContext, w, h);
        if (context == 0L) {
            return new byte[0];
        }
        OS.CGContextSetRGBFillColor(context, 1.0, 1.0, 1.0, 1.0);
        CGRect rect = new CGRect();
        rect.size.width = w;
        rect.size.height = h;
        OS.CGContextFillRect(context, rect);
        double drawX = 0.0;
        double drawY = 0.0;
        if (matrix != null) {
            OS.CGContextTranslateCTM(context, -x, -y);
        } else {
            drawX = x - (double)this.strike.getSubPixelPosition(subPixel);
            drawY = y;
        }
        OS.CGContextSetRGBFillColor(context, 0.0, 0.0, 0.0, 1.0);
        OS.CTFontDrawGlyphs(fontRef, (short)this.glyphCode, -drawX, -drawY, context);
        if (matrix != null) {
            OS.CGContextTranslateCTM(context, x, y);
        }
        if ((imageData = lcd ? OS.CGBitmapContextGetData(context, w, h, 24) : OS.CGBitmapContextGetData(context, w, h, 8)) == null) {
            this.bounds = new CGRect();
            imageData = new byte[]{};
        }
        if (!cache) {
            OS.CGContextRelease(context);
        }
        return imageData;
    }

    @Override
    public byte[] getPixelData() {
        return this.getPixelData(0);
    }

    @Override
    public byte[] getPixelData(int subPixel) {
        this.checkBounds();
        return this.getImage(this.bounds.origin.x, this.bounds.origin.y, (int)this.bounds.size.width, (int)this.bounds.size.height, subPixel);
    }

    @Override
    public float getAdvance() {
        this.checkBounds();
        return (float)this.xAdvance;
    }

    @Override
    public float getPixelXAdvance() {
        this.checkBounds();
        return (float)this.xAdvance;
    }

    @Override
    public float getPixelYAdvance() {
        this.checkBounds();
        return (float)this.yAdvance;
    }

    @Override
    public int getWidth() {
        this.checkBounds();
        int w = (int)this.bounds.size.width;
        return this.isLCDGlyph() ? w * 3 : w;
    }

    @Override
    public int getHeight() {
        this.checkBounds();
        return (int)this.bounds.size.height;
    }

    @Override
    public int getOriginX() {
        this.checkBounds();
        return (int)this.bounds.origin.x;
    }

    @Override
    public int getOriginY() {
        this.checkBounds();
        int h = (int)this.bounds.size.height;
        int y = (int)this.bounds.origin.y;
        return -h - y;
    }

    @Override
    public boolean isLCDGlyph() {
        return this.strike.getAAMode() == 1;
    }

    static {
        GRAY_COLORSPACE = OS.CGColorSpaceCreateDeviceGray();
        RGB_COLORSPACE = OS.CGColorSpaceCreateDeviceRGB();
    }
}

