/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javafx.font;

import com.sun.javafx.font.FontFactory;
import com.sun.javafx.font.Metrics;
import com.sun.javafx.font.PGFont;
import com.sun.javafx.font.PrismFontFactory;
import com.sun.javafx.font.PrismFontUtils;
import com.sun.javafx.scene.text.FontHelper;
import com.sun.javafx.tk.FontLoader;
import com.sun.javafx.tk.FontMetrics;
import java.io.InputStream;
import java.lang.reflect.Method;
import java.net.URL;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.List;
import java.util.Properties;
import javafx.scene.text.Font;
import javafx.scene.text.FontPosture;
import javafx.scene.text.FontWeight;

public class PrismFontLoader
extends FontLoader {
    private static PrismFontLoader theInstance = new PrismFontLoader();
    private boolean embeddedFontsLoaded = false;
    FontFactory installedFontFactory = null;

    public static PrismFontLoader getInstance() {
        return theInstance;
    }

    Properties loadEmbeddedFontDefinitions() {
        Properties map = new Properties();
        ClassLoader loader = Thread.currentThread().getContextClassLoader();
        if (loader == null) {
            return map;
        }
        URL u = loader.getResource("META-INF/fonts.mf");
        if (u == null) {
            return map;
        }
        try (InputStream in = u.openStream();){
            map.load(in);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return map;
    }

    private void loadEmbeddedFonts() {
        if (!this.embeddedFontsLoaded) {
            FontFactory fontFactory = this.getFontFactoryFromPipeline();
            if (!fontFactory.hasPermission()) {
                this.embeddedFontsLoaded = true;
                return;
            }
            Properties map = this.loadEmbeddedFontDefinitions();
            Enumeration<Object> names = map.keys();
            ClassLoader loader = Thread.currentThread().getContextClassLoader();
            while (names.hasMoreElements()) {
                String n = (String)names.nextElement();
                String p = map.getProperty(n);
                if (!p.startsWith("/")) continue;
                p = p.substring(1);
                try {
                    InputStream in = loader.getResourceAsStream(p);
                    try {
                        fontFactory.loadEmbeddedFont(n, in, 0.0f, true, false);
                    }
                    finally {
                        if (in == null) continue;
                        in.close();
                    }
                }
                catch (Exception exception) {}
            }
            this.embeddedFontsLoaded = true;
        }
    }

    private Font[] createFonts(PGFont[] fonts) {
        if (fonts == null || fonts.length == 0) {
            return null;
        }
        Font[] fxFonts = new Font[fonts.length];
        for (int i = 0; i < fonts.length; ++i) {
            fxFonts[i] = this.createFont(fonts[i]);
        }
        return fxFonts;
    }

    @Override
    public Font[] loadFont(InputStream in, double size, boolean loadAll) {
        FontFactory factory = this.getFontFactoryFromPipeline();
        PGFont[] fonts = factory.loadEmbeddedFont(null, in, (float)size, true, loadAll);
        return this.createFonts(fonts);
    }

    @Override
    public Font[] loadFont(String path, double size, boolean loadAll) {
        FontFactory factory = this.getFontFactoryFromPipeline();
        PGFont[] fonts = factory.loadEmbeddedFont(null, path, (float)size, true, loadAll);
        return this.createFonts(fonts);
    }

    private Font createFont(PGFont font) {
        return FontHelper.nativeFont(font, font.getName(), font.getFamilyName(), font.getStyleName(), font.getSize());
    }

    @Override
    public List<String> getFamilies() {
        this.loadEmbeddedFonts();
        return Arrays.asList(this.getFontFactoryFromPipeline().getFontFamilyNames());
    }

    @Override
    public List<String> getFontNames() {
        this.loadEmbeddedFonts();
        return Arrays.asList(this.getFontFactoryFromPipeline().getFontFullNames());
    }

    @Override
    public List<String> getFontNames(String family) {
        this.loadEmbeddedFonts();
        return Arrays.asList(this.getFontFactoryFromPipeline().getFontFullNames(family));
    }

    @Override
    public Font font(String family, FontWeight weight, FontPosture posture, float size) {
        FontFactory fontFactory = this.getFontFactoryFromPipeline();
        if (!this.embeddedFontsLoaded && !fontFactory.isPlatformFont(family)) {
            this.loadEmbeddedFonts();
        }
        boolean bold = weight != null && weight.ordinal() >= FontWeight.BOLD.ordinal();
        boolean italic = posture == FontPosture.ITALIC;
        PGFont prismFont = fontFactory.createFont(family, bold, italic, size);
        Font fxFont = FontHelper.nativeFont(prismFont, prismFont.getName(), prismFont.getFamilyName(), prismFont.getStyleName(), size);
        return fxFont;
    }

    @Override
    public void loadFont(Font font) {
        FontFactory fontFactory = this.getFontFactoryFromPipeline();
        String fullName = font.getName();
        if (!this.embeddedFontsLoaded && !fontFactory.isPlatformFont(fullName)) {
            this.loadEmbeddedFonts();
        }
        PGFont prismFont = fontFactory.createFont(fullName, (float)font.getSize());
        String name = prismFont.getName();
        String family = prismFont.getFamilyName();
        String style = prismFont.getStyleName();
        FontHelper.setNativeFont(font, prismFont, name, family, style);
    }

    @Override
    public FontMetrics getFontMetrics(Font font) {
        if (font != null) {
            PGFont prismFont = (PGFont)FontHelper.getNativeFont(font);
            Metrics metrics = PrismFontUtils.getFontMetrics(prismFont);
            float maxAscent = -metrics.getAscent();
            float ascent = -metrics.getAscent();
            float xheight = metrics.getXHeight();
            float descent = metrics.getDescent();
            float maxDescent = metrics.getDescent();
            float leading = metrics.getLineGap();
            return FontMetrics.createFontMetrics(maxAscent, ascent, xheight, descent, maxDescent, leading, font);
        }
        return null;
    }

    @Override
    public float getCharWidth(char ch, Font font) {
        PGFont prismFont = (PGFont)FontHelper.getNativeFont(font);
        return (float)PrismFontUtils.getCharWidth(prismFont, ch);
    }

    @Override
    public float getSystemFontSize() {
        return PrismFontFactory.getSystemFontSize();
    }

    private FontFactory getFontFactoryFromPipeline() {
        if (this.installedFontFactory != null) {
            return this.installedFontFactory;
        }
        try {
            Class<?> plc = Class.forName("com.sun.prism.GraphicsPipeline");
            Method gpm = plc.getMethod("getPipeline", null);
            Object plo = gpm.invoke(null, new Object[0]);
            Method gfm = plc.getMethod("getFontFactory", null);
            Object ffo = gfm.invoke(plo, new Object[0]);
            this.installedFontFactory = (FontFactory)ffo;
        }
        catch (Exception exception) {
            // empty catch block
        }
        return this.installedFontFactory;
    }
}

