/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javafx.application;

import java.lang.module.ModuleDescriptor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Optional;

public final class ModuleAccess {
    private final Object module;
    private static final Method bootLayerMethod;
    private static final Method getModuleNameMethod;
    private static final Method findModuleMethod;
    private static final Method getDescriptorMethod;
    private static final Method classForNameMethod;

    private ModuleAccess(Object m) {
        this.module = m;
    }

    ModuleDescriptor getDescriptor() {
        try {
            return (ModuleDescriptor)getDescriptorMethod.invoke(this.module, new Object[0]);
        }
        catch (IllegalAccessException | InvocationTargetException e) {
            throw new InternalError(e);
        }
    }

    String getName() {
        try {
            return (String)getModuleNameMethod.invoke(this.module, new Object[0]);
        }
        catch (IllegalAccessException | InvocationTargetException e) {
            throw new InternalError(e);
        }
    }

    Class<?> classForName(String name) {
        try {
            return (Class)classForNameMethod.invoke(null, this.module, name);
        }
        catch (IllegalAccessException | InvocationTargetException e) {
            throw new InternalError(e);
        }
    }

    static ModuleAccess load(String moduleName) {
        try {
            Object layer = bootLayerMethod.invoke(null, new Object[0]);
            Optional om = (Optional)findModuleMethod.invoke(layer, moduleName);
            if (!om.isPresent()) {
                throw new InternalError("Module " + moduleName + " not in boot Layer");
            }
            return new ModuleAccess(om.get());
        }
        catch (IllegalAccessException | InvocationTargetException e) {
            throw new InternalError(e);
        }
    }

    static {
        Class<?> cModuleClass = null;
        Method mGetModule = null;
        Method mGetLayer = null;
        Method mGetDescriptor = null;
        Method mGetName = null;
        Method mBootLayers = null;
        Method mfindModule = null;
        Method mClassForName = null;
        try {
            mGetModule = Class.class.getMethod("getModule", new Class[0]);
            cModuleClass = mGetModule.getReturnType();
            mGetLayer = cModuleClass.getMethod("getLayer", new Class[0]);
            mGetDescriptor = cModuleClass.getMethod("getDescriptor", new Class[0]);
            mGetName = cModuleClass.getMethod("getName", new Class[0]);
            Class<?> layerClass = mGetLayer.getReturnType();
            mBootLayers = layerClass.getMethod("boot", new Class[0]);
            mfindModule = layerClass.getMethod("findModule", String.class);
            mClassForName = Class.class.getMethod("forName", cModuleClass, String.class);
        }
        catch (NoSuchMethodException e) {
            throw new InternalError("Module reflection failed", e);
        }
        bootLayerMethod = mBootLayers;
        getModuleNameMethod = mGetName;
        getDescriptorMethod = mGetDescriptor;
        findModuleMethod = mfindModule;
        classForNameMethod = mClassForName;
    }
}

