/*
 * Copyright (c) 2005 Sun Microsystems, Inc. All Rights Reserved.
 * 
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are
 * met:
 * 
 * - Redistribution of source code must retain the above copyright
 *   notice, this list of conditions and the following disclaimer.
 * 
 * - Redistribution in binary form must reproduce the above copyright
 *   notice, this list of conditions and the following disclaimer in the
 *   documentation and/or other materials provided with the distribution.
 * 
 * Neither the name of Sun Microsystems, Inc. or the names of
 * contributors may be used to endorse or promote products derived from
 * this software without specific prior written permission.
 * 
 * This software is provided "AS IS," without a warranty of any kind. ALL
 * EXPRESS OR IMPLIED CONDITIONS, REPRESENTATIONS AND WARRANTIES,
 * INCLUDING ANY IMPLIED WARRANTY OF MERCHANTABILITY, FITNESS FOR A
 * PARTICULAR PURPOSE OR NON-INFRINGEMENT, ARE HEREBY EXCLUDED. SUN
 * MICROSYSTEMS, INC. ("SUN") AND ITS LICENSORS SHALL NOT BE LIABLE FOR
 * ANY DAMAGES SUFFERED BY LICENSEE AS A RESULT OF USING, MODIFYING OR
 * DISTRIBUTING THIS SOFTWARE OR ITS DERIVATIVES. IN NO EVENT WILL SUN OR
 * ITS LICENSORS BE LIABLE FOR ANY LOST REVENUE, PROFIT OR DATA, OR FOR
 * DIRECT, INDIRECT, SPECIAL, CONSEQUENTIAL, INCIDENTAL OR PUNITIVE
 * DAMAGES, HOWEVER CAUSED AND REGARDLESS OF THE THEORY OF LIABILITY,
 * ARISING OUT OF THE USE OF OR INABILITY TO USE THIS SOFTWARE, EVEN IF
 * SUN HAS BEEN ADVISED OF THE POSSIBILITY OF SUCH DAMAGES.
 * 
 * You acknowledge that this software is not designed or intended for use
 * in the design, construction, operation or maintenance of any nuclear
 * facility.
 * 
 * Sun gratefully acknowledges that this software was originally authored
 * and developed by Kenneth Bradley Russell and Christopher John Kline.
 */

package demos.xtrans;

import gleem.linalg.*;

/** A quadrilateral of two-dimensional floating-point values which
 * interpolates between specified start and end values.
 *
 * @author Kenneth Russell
 */

public class InterpolatedQuad2f {
  private Quad2f start;
  private Quad2f end;

  /** Constructs a new InterpolatedQuad2f. By default both the start
      and end quadrilaterals have all of their points set to the
      origin. */
  public InterpolatedQuad2f() {
    start = new Quad2f();
    end = new Quad2f();
  }

  /** Returns the starting value for the interpolation. */
  public Quad2f getStart() {
    return start;
  }

  /** Sets the starting value for the interpolation. */
  public void setStart(Quad2f quad) {
    start.set(quad);
  }

  /** Returns the ending value for the interpolation. */
  public Quad2f getEnd() {
    return end;
  }

  /** Sets the ending value for the interpolation. */
  public void setEnd(Quad2f quad) {
    end.set(quad);
  }

  /** Gets the current interpolated value at the specified fraction of
      interpolation (0.0 - 1.0). */
  public Quad2f getCurrent(float fraction) {
    return start.times(1.0f - fraction).plus(end.times(fraction));
  }
}
