/*
 * Decompiled with CFR 0.152.
 */
package simple.xml.stream;

import javax.xml.stream.XMLEventReader;
import javax.xml.stream.events.Characters;
import javax.xml.stream.events.StartElement;
import javax.xml.stream.events.XMLEvent;
import simple.xml.stream.InputElement;
import simple.xml.stream.InputNode;
import simple.xml.stream.InputStack;

final class NodeReader {
    private XMLEventReader reader;
    private InputStack stack = new InputStack();

    public NodeReader(XMLEventReader reader) {
        this.reader = reader;
    }

    public InputNode readRoot() throws Exception {
        if (this.stack.isEmpty()) {
            return this.readElement(null);
        }
        return null;
    }

    public InputNode readElement(InputNode from) throws Exception {
        if (!this.stack.contains(from) && !this.stack.isEmpty()) {
            return null;
        }
        XMLEvent event = this.reader.nextEvent();
        while (event != null) {
            if (event.isEndElement()) {
                if (this.stack.pop() == from) {
                    return null;
                }
            } else if (event.isStartElement()) {
                return this.readStart(from, event);
            }
            event = this.reader.nextEvent();
        }
        return null;
    }

    private InputNode readStart(InputNode from, XMLEvent event) throws Exception {
        StartElement start = event.asStartElement();
        InputElement input = new InputElement(this, start);
        return this.stack.push(input);
    }

    public String readValue(InputNode from) throws Exception {
        StringBuilder value = new StringBuilder();
        while (this.stack.top() == from) {
            XMLEvent event = this.reader.peek();
            if (!event.isCharacters()) {
                if (value.length() == 0) {
                    return null;
                }
                return value.toString();
            }
            Characters text = event.asCharacters();
            String data = text.getData();
            value.append(data);
            this.reader.nextEvent();
        }
        return null;
    }
}

