/*
 * Decompiled with CFR 0.152.
 */
package simple.xml.load;

import java.util.HashMap;
import java.util.Map;
import simple.xml.filter.Filter;
import simple.xml.load.Scanner;
import simple.xml.load.ScannerCache;
import simple.xml.load.Schema;
import simple.xml.load.Strategy;
import simple.xml.load.TemplateEngine;
import simple.xml.load.TemplateFilter;
import simple.xml.stream.InputNode;
import simple.xml.stream.NodeMap;
import simple.xml.stream.OutputNode;

final class Source {
    private static ScannerCache cache = new ScannerCache();
    private TemplateEngine engine;
    private Strategy strategy;
    private Filter filter;
    private Map table;
    private int read;
    private int write;

    public Source(Strategy strategy, Filter data) {
        this.filter = new TemplateFilter(this, data);
        this.engine = new TemplateEngine(this.filter);
        this.table = new HashMap();
        this.strategy = strategy;
    }

    public Object getAttribute(Object key) {
        return this.table.get(key);
    }

    public Class getOverride(Class type, InputNode node) throws Exception {
        NodeMap map = node.getAttributes();
        if (this.read++ == 0) {
            return this.strategy.readRoot(type, map, this.table);
        }
        return this.strategy.readElement(type, map, this.table);
    }

    public void setOverride(Class type, Object value, OutputNode node) throws Exception {
        NodeMap map = node.getAttributes();
        if (this.write++ == 0) {
            this.strategy.writeRoot(type, value, map, this.table);
        }
        this.strategy.writeElement(type, value, map, this.table);
    }

    public Schema getSchema(Object source) {
        return this.getSchema(source.getClass());
    }

    public Schema getSchema(Class type) {
        Scanner schema = (Scanner)cache.get(type);
        if (schema == null) {
            schema = new Scanner(type);
            cache.cache(type, schema);
        }
        return new Schema(schema, this.table);
    }

    public String getProperty(String text) {
        return this.engine.process(text);
    }
}

