/*
 * Decompiled with CFR 0.152.
 */
package simple.xml.load;

import java.lang.reflect.Modifier;
import simple.xml.load.InstantiationException;
import simple.xml.load.Source;
import simple.xml.stream.InputNode;
import simple.xml.stream.OutputNode;

abstract class Factory {
    protected Source source;
    protected Class field;

    protected Factory(Source source, Class field) {
        this.source = source;
        this.field = field;
    }

    public Class getOverride(InputNode node) throws Exception {
        Class type = this.getConversion(node);
        if (type != null && !this.isCompatible(this.field, type)) {
            throw new InstantiationException("Type %s is not compatible with %s", type, this.field);
        }
        return type;
    }

    public void setOverride(Class field, Object value, OutputNode node) throws Exception {
        Class<?> type = value.getClass();
        if (!this.isPrimitive(type)) {
            this.source.setOverride(field, value, node);
        }
    }

    public Class getConversion(InputNode node) throws Exception {
        return this.source.getOverride(this.field, node);
    }

    public boolean isCompatible(Class field, Class type) {
        return field.isAssignableFrom(type);
    }

    public boolean isInstantiable(Class type) {
        int modifiers = type.getModifiers();
        if (Modifier.isAbstract(modifiers)) {
            return false;
        }
        return !Modifier.isInterface(modifiers);
    }

    protected boolean isPrimitive(Class type) {
        if (type.equals(Boolean.class)) {
            return true;
        }
        if (type.equals(Integer.class)) {
            return true;
        }
        if (type.equals(Float.class)) {
            return true;
        }
        if (type.equals(Long.class)) {
            return true;
        }
        if (type.equals(Double.class)) {
            return true;
        }
        if (type.equals(Byte.class)) {
            return true;
        }
        if (type.equals(Short.class)) {
            return true;
        }
        return type.isPrimitive();
    }
}

