/*
 * Decompiled with CFR 0.152.
 */
package simple.xml.load;

import java.lang.reflect.Field;
import simple.xml.Element;
import simple.xml.load.Composite;
import simple.xml.load.Converter;
import simple.xml.load.Label;
import simple.xml.load.Primitive;
import simple.xml.load.Source;

final class ElementLabel
implements Label {
    private Element label;
    private Field field;
    private Class type;

    public ElementLabel(Field field, Element label) {
        this.type = field.getType();
        this.label = label;
        this.field = field;
    }

    public Converter getConverter(Source source) {
        if (this.isPrimitive(this.type)) {
            return new Primitive(source, this.type);
        }
        return new Composite(source, this.type);
    }

    public Field getField() {
        return this.field;
    }

    public String getName() {
        return this.label.name();
    }

    public Class getType() {
        return this.type;
    }

    public boolean isRequired() {
        return this.label.required();
    }

    private boolean isPrimitive(Class type) {
        if (type.equals(Boolean.class)) {
            return true;
        }
        if (type.equals(Integer.class)) {
            return true;
        }
        if (type.equals(Float.class)) {
            return true;
        }
        if (type.equals(Long.class)) {
            return true;
        }
        if (type.equals(String.class)) {
            return true;
        }
        if (type.equals(Double.class)) {
            return true;
        }
        if (type.equals(Byte.class)) {
            return true;
        }
        if (type.equals(Short.class)) {
            return true;
        }
        if (type.isPrimitive()) {
            return true;
        }
        return type.isEnum();
    }

    public String toString() {
        return this.label.toString();
    }
}

