/*
 * Decompiled with CFR 0.152.
 */
package simple.xml.load;

import java.util.Collection;
import simple.xml.load.CollectionFactory;
import simple.xml.load.Converter;
import simple.xml.load.Source;
import simple.xml.load.Traverser;
import simple.xml.stream.InputNode;
import simple.xml.stream.OutputNode;

final class CompositeList
implements Converter {
    private CollectionFactory factory;
    private Traverser root;
    private Class entry;

    public CompositeList(Source root, Class type, Class entry) {
        this.factory = new CollectionFactory(root, type);
        this.root = new Traverser(root);
        this.entry = entry;
    }

    public Object read(InputNode node) throws Exception {
        InputNode next;
        Collection list = this.factory.getInstance(node);
        while ((next = node.getNext()) != null) {
            list.add(this.root.read(next, this.entry));
        }
        return list;
    }

    public void write(OutputNode node, Object source) throws Exception {
        Collection list = (Collection)source;
        for (Object item : list) {
            Class<?> type = item.getClass();
            if (!this.entry.isAssignableFrom(type)) {
                throw new RuntimeException("Type does not match list entry");
            }
            this.root.write(node, item, this.entry);
        }
    }
}

