/*
 * Decompiled with CFR 0.152.
 */
package simple.xml.load;

import java.lang.reflect.Field;
import simple.xml.load.AttributeException;
import simple.xml.load.Converter;
import simple.xml.load.ElementException;
import simple.xml.load.FieldRequiredException;
import simple.xml.load.Label;
import simple.xml.load.LabelMap;
import simple.xml.load.ObjectFactory;
import simple.xml.load.Schema;
import simple.xml.load.Source;
import simple.xml.stream.InputNode;
import simple.xml.stream.NodeMap;
import simple.xml.stream.OutputNode;
import simple.xml.stream.Position;

final class Composite
implements Converter {
    private ObjectFactory factory;
    private Source root;

    public Composite(Source root, Class type) {
        this.factory = new ObjectFactory(root, type);
        this.root = root;
    }

    public Object read(InputNode node) throws Exception {
        Object source = this.factory.getInstance(node);
        this.read(node, source);
        return source;
    }

    private void read(InputNode node, Object source) throws Exception {
        Schema schema = this.root.getSchema(source);
        this.read(node, source, schema);
        schema.validate(source);
        schema.commit(source);
    }

    private void read(InputNode node, Object source, Schema schema) throws Exception {
        this.readAttributes(node, source, schema);
        this.readElements(node, source, schema);
    }

    private void readAttributes(InputNode node, Object source, Schema schema) throws Exception {
        NodeMap list = node.getAttributes();
        LabelMap map = schema.getAttributes();
        for (String name : list) {
            this.readAttribute(node.getAttribute(name), source, map);
        }
        this.validate(map, source);
    }

    private void readElements(InputNode node, Object source, Schema schema) throws Exception {
        InputNode child;
        LabelMap map = schema.getElements();
        while ((child = node.getNext()) != null) {
            this.readElement(child, source, map);
        }
        this.validate(map, source);
    }

    private void readAttribute(InputNode node, Object source, LabelMap map) throws Exception {
        Position line = node.getPosition();
        String name = node.getName();
        Label label = map.take(name);
        if (label == null) {
            throw new AttributeException("Attribute '%s' does not exist at %s", name, line);
        }
        this.read(node, source, label);
    }

    private void readElement(InputNode node, Object source, LabelMap map) throws Exception {
        Position line = node.getPosition();
        String name = node.getName();
        Label label = map.take(name);
        if (label == null) {
            throw new ElementException("Element '%s' does not exist at %s", name, line);
        }
        this.read(node, source, label);
    }

    private void read(InputNode node, Object source, Label label) throws Exception {
        Converter reader = label.getConverter(this.root);
        Field field = label.getField();
        Object object = reader.read(node);
        if (object == null) {
            Class<?> type = source.getClass();
            if (label.isRequired()) {
                throw new FieldRequiredException("Empty value for %s in %s", label, type);
            }
        } else {
            field.set(source, object);
        }
    }

    private void validate(LabelMap map, Object source) throws Exception {
        Class<?> type = source.getClass();
        String name = type.getName();
        for (Label label : map) {
            if (!label.isRequired()) continue;
            throw new FieldRequiredException("Unable to satisfy %s for %s", label, name);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void write(OutputNode node, Object source) throws Exception {
        Schema schema = this.root.getSchema(source);
        try {
            schema.persist(source);
            this.write(node, source, schema);
        }
        finally {
            schema.complete(source);
        }
    }

    private void write(OutputNode node, Object source, Schema schema) throws Exception {
        this.writeAttributes(node, source, schema);
        this.writeElements(node, source, schema);
    }

    private void writeAttributes(OutputNode node, Object source, Schema schema) throws Exception {
        LabelMap attributes = schema.getAttributes();
        for (Label label : attributes) {
            Field field = label.getField();
            Object value = field.get(source);
            if (label.isRequired() && value == null) {
                throw new AttributeException("Value for %s is null", label);
            }
            this.writeAttribute(node, value, label);
        }
    }

    private void writeElements(OutputNode node, Object source, Schema schema) throws Exception {
        LabelMap elements = schema.getElements();
        for (Label label : elements) {
            Field field = label.getField();
            Object value = field.get(source);
            if (label.isRequired() && value == null) {
                throw new ElementException("Value for %s is null", label);
            }
            this.writeElement(node, value, label);
        }
    }

    private void writeAttribute(OutputNode node, Object value, Label label) throws Exception {
        if (value != null) {
            String name = label.getName();
            String text = value.toString();
            if (value instanceof Enum) {
                Enum type = (Enum)value;
                text = type.name();
            }
            node.setAttribute(name, text);
        }
    }

    private void writeElement(OutputNode node, Object value, Label label) throws Exception {
        if (value != null) {
            String name = label.getName();
            OutputNode next = node.getChild(name);
            Class type = label.getType();
            this.factory.setOverride(type, value, next);
            label.getConverter(this.root).write(next, value);
        }
    }
}

